/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.schedule.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.schedule.dao.ScheduleJobMapper;
import com.els.base.schedule.entity.ScheduleJob;
import com.els.base.schedule.entity.ScheduleJobExample;
import com.els.base.schedule.plugin.QuartzManager;
import com.els.base.schedule.service.ScheduleJobService;
import com.els.base.utils.SpringContextHolder;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service(value="defaultScheduleJobService")
public class ScheduleJobServiceImpl
implements ScheduleJobService {
    private static final Logger logger = LoggerFactory.getLogger(ScheduleJobServiceImpl.class);
    @Resource
    protected ScheduleJobMapper scheduleJobMapper;
    private QuartzManager quartzManager;

    private QuartzManager getQuartzManager() {
        if (this.quartzManager == null) {
            this.quartzManager = (QuartzManager)SpringContextHolder.getOneBean(QuartzManager.class);
        }
        if (this.quartzManager == null) {
            throw new CommonException("\u7cfb\u7edf\u672a\u5f00\u542f\u5b9a\u65f6\u4efb\u52a1\u529f\u80fd");
        }
        return this.quartzManager;
    }

    @CacheEvict(value={"scheduleJob"}, allEntries=true)
    public void addObj(ScheduleJob scheduleJob) {
        boolean beanExist;
        Assert.isNotNull((Object)scheduleJob, (String)"\u5b9a\u65f6\u4efb\u52a1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotBlank((String)scheduleJob.getJobClass(), (String)"\u5b9a\u65f6\u4efb\u52a1\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        Assert.isNotBlank((String)scheduleJob.getCronExpression(), (String)"\u5b9a\u65f6\u4efb\u52a1Cron\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        scheduleJob.setCreateTime(new Date());
        scheduleJob.setUpdateTime(new Date());
        if (ObjectUtils.isEmpty((Object)scheduleJob.getJobState())) {
            scheduleJob.setJobState(Constant.NO_INT);
        }
        if (!(beanExist = this.isBeanExist(scheduleJob.getJobClass()))) {
            throw new CommonException("\u6267\u884c\u4efb\u52a1\u7c7b\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        if (!this.getQuartzManager().isCronCorrect(scheduleJob.getCronExpression())) {
            throw new CommonException("cron \u8868\u8fbe\u5f0f\u9519\u8bef", "expression_error");
        }
        try {
            this.getQuartzManager().addJob(scheduleJob);
        }
        catch (SchedulerException e) {
            logger.error("\u6dfb\u52a0\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
            throw new CommonException("\u6dfb\u52a0\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
        }
        if (this.checkExists(scheduleJob)) {
            throw new CommonException("\u5b9a\u65f6\u5668\u7684\u7f16\u7801\u3010" + scheduleJob.getJobCode() + "\u3011\u5df2\u7ecf\u5b58\u5728,\u8bf7\u68c0\u67e5\uff01");
        }
        this.scheduleJobMapper.insertSelective(scheduleJob);
    }

    @CacheEvict(value={"scheduleJob"}, allEntries=true)
    public void deleteObjById(String id) {
        Assert.isNotBlank((String)id, (String)"ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        ScheduleJob scheduleJob = this.queryObjById(id);
        Assert.isNotNull((Object)scheduleJob, (String)"\u5b9a\u65f6\u4efb\u52a1\u4e0d\u5b58\u5728");
        if (ScheduleJob.JOB_STATE_NORMAL.equals(scheduleJob.getJobState())) {
            throw new CommonException("job \u5df2\u542f\u52a8\uff0c\u8bf7\u505c\u6b62\u540e\u64cd\u4f5c", "base_fail");
        }
        try {
            this.getQuartzManager().deleteJob(scheduleJob);
        }
        catch (SchedulerException e) {
            logger.error("\u5220\u9664\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
            throw new CommonException("\u5220\u9664\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
        }
        this.scheduleJobMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"scheduleJob"}, allEntries=true)
    public void modifyObj(ScheduleJob scheduleJob) {
        Assert.isNotBlank((String)scheduleJob.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25", (String)"id_is_blank");
        ScheduleJob tmp = this.queryObjById(scheduleJob.getId());
        Assert.isNotNull((Object)tmp, (String)"\u5b9a\u65f6\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01");
        if (ScheduleJob.JOB_STATE_NORMAL.equals(tmp.getJobState())) {
            throw new CommonException("job \u5df2\u542f\u52a8\uff0c\u8bf7\u505c\u6b62\u540e\u4fee\u6539", "base_fail");
        }
        Assert.isNotBlank((String)scheduleJob.getCronExpression(), (String)"cron\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)scheduleJob.getJobCode(), (String)"jobcode\u4e0d\u80fd\u4e3a\u7a7a");
        if (!this.getQuartzManager().isCronCorrect(scheduleJob.getCronExpression())) {
            throw new CommonException("cron \u8868\u8fbe\u5f0f\u9519\u8bef", "expression_error");
        }
        scheduleJob.setUpdateTime(new Date());
        this.scheduleJobMapper.updateByPrimaryKeySelective(scheduleJob);
    }

    @Cacheable(value={"scheduleJob"}, keyGenerator="redisKeyGenerator")
    public ScheduleJob queryObjById(String id) {
        return this.scheduleJobMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"scheduleJob"}, keyGenerator="redisKeyGenerator")
    public List<ScheduleJob> queryAllObjByExample(ScheduleJobExample example) {
        return this.scheduleJobMapper.selectByExample(example);
    }

    @Cacheable(value={"scheduleJob"}, keyGenerator="redisKeyGenerator")
    public PageView<ScheduleJob> queryObjByPage(ScheduleJobExample example) {
        PageView<ScheduleJob> pageView = example.getPageView();
        pageView.setQueryResult(this.scheduleJobMapper.selectByExampleByPage(example));
        return pageView;
    }

    @CacheEvict(value={"scheduleJob"}, allEntries=true)
    public void deleteByExample(ScheduleJobExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.scheduleJobMapper.deleteByExample(example);
    }

    @CacheEvict(value={"scheduleJob"}, allEntries=true)
    @Transactional
    public void addAll(List<ScheduleJob> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> this.addObj((ScheduleJob)record));
    }

    @Override
    public boolean checkExists(ScheduleJob job) {
        ScheduleJobExample example = new ScheduleJobExample();
        ScheduleJobExample.Criteria cri = example.createCriteria().andJobCodeEqualTo(job.getJobCode());
        if (StringUtils.isNotBlank((String)job.getJobGroup())) {
            cri.andJobGroupEqualTo(job.getJobGroup());
        }
        return this.scheduleJobMapper.countByExample(example) > 0;
    }

    private boolean isBeanExist(String jobClass) {
        if (StringUtils.isBlank((String)jobClass)) {
            return false;
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        Class<?> clazz = null;
        try {
            clazz = classLoader.loadClass(jobClass);
            Object bean = SpringContextHolder.getOneBean(clazz);
            if (bean == null) {
                return false;
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new CommonException("\u5305\u540d\u548c\u7c7b\u540d\u662f\u5426\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        return true;
    }

    @Override
    @CacheEvict(value={"scheduleJob"}, allEntries=true)
    public void modifyStatus(String id, Integer jobStatus, Integer isEnable) {
        if (jobStatus == null && isEnable == null) {
            throw new CommonException("\u72b6\u6001\u4e3a\u7a7a\u65e0\u6cd5\u53d8\u66f4\u72b6\u6001");
        }
        ScheduleJob scheduleJob = new ScheduleJob();
        scheduleJob.setId(id);
        scheduleJob.setJobState(jobStatus);
        scheduleJob.setIsEnable(isEnable);
        this.scheduleJobMapper.updateByPrimaryKeySelective(scheduleJob);
    }
}

