/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.schedule.plugin.impl;

import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.schedule.entity.ScheduleJob;
import com.els.base.schedule.entity.ScheduleJobExample;
import com.els.base.schedule.plugin.DynamicJob;
import com.els.base.schedule.plugin.QuartzManager;
import com.els.base.schedule.service.ScheduleJobService;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class QuartzManagerImpl
implements QuartzManager {
    private static final Logger logger = LoggerFactory.getLogger(QuartzManagerImpl.class);
    @Autowired
    protected ScheduleJobService scheduleJobService;
    @Value(value="${job.is.enable:true}")
    protected String isJobEnalbe;
    private static Scheduler scheduler = null;
    public static String JOB_PARAM_KEY = "JOB_PARAM_KEY";

    public QuartzManagerImpl(Scheduler stdScheduler) {
        scheduler = stdScheduler;
    }

    @Override
    public JobDataMap getJobDataMap(ScheduleJob job) {
        JobDataMap map = new JobDataMap();
        map.put(JOB_PARAM_KEY, (Object)job);
        return map;
    }

    @Override
    public JobDetail getJobDetail(ScheduleJob job) {
        return JobBuilder.newJob(DynamicJob.class).withIdentity(this.getJobKey(job)).withDescription(job.getJobName()).setJobData(this.getJobDataMap(job)).storeDurably().build();
    }

    @Override
    public Trigger getTrigger(ScheduleJob job) {
        if (StringUtils.isBlank((String)job.getJobGroup())) {
            return TriggerBuilder.newTrigger().withIdentity(job.getJobCode(), "DEFAULT").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)job.getCronExpression())).build();
        }
        return TriggerBuilder.newTrigger().withIdentity(job.getJobCode(), job.getJobGroup()).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)job.getCronExpression())).build();
    }

    @Override
    public JobKey getJobKey(ScheduleJob job) {
        if (StringUtils.isBlank((String)job.getJobGroup())) {
            return JobKey.jobKey((String)job.getJobCode(), (String)"DEFAULT");
        }
        return JobKey.jobKey((String)job.getJobCode(), (String)job.getJobGroup());
    }

    @Override
    public TriggerKey getTriggerKey(ScheduleJob job) {
        if (StringUtils.isBlank((String)job.getJobGroup())) {
            return TriggerKey.triggerKey((String)job.getJobCode(), (String)"DEFAULT");
        }
        return TriggerKey.triggerKey((String)job.getJobCode(), (String)job.getJobGroup());
    }

    public List<ScheduleJob> loadJobs() {
        ScheduleJobExample scheduleJobExample = new ScheduleJobExample();
        List scheduleJobs = this.scheduleJobService.queryAllObjByExample((IExample)scheduleJobExample);
        return scheduleJobs;
    }

    @Override
    public JobDetail addJob(ScheduleJob job) throws SchedulerException {
        if (!this.checkSwitch()) {
            throw new CommonException("\u672c\u5e94\u7528\uff0c\u6ca1\u6709\u5f00\u542f\u5b9a\u65f6\u4efb\u52a1\u529f\u80fd\uff0c\u8bf7\u5728 conf.properties\u6587\u4ef6\u4e2d\u914d\u7f6e\u5f00\u542f", "base_fail");
        }
        JobDetail jobDetail = this.getJobDetail(job);
        scheduler.addJob(jobDetail, true);
        return jobDetail;
    }

    @Override
    public void runJobNow(ScheduleJob job) throws SchedulerException {
        JobKey jobKey = this.getJobKey(job);
        if (scheduler.checkExists(jobKey)) {
            scheduler.triggerJob(jobKey);
        } else {
            this.addJob(job);
            scheduler.triggerJob(jobKey);
        }
    }

    @Override
    public void pauseJob(ScheduleJob job) throws SchedulerException {
        if (!this.checkSwitch()) {
            throw new CommonException("\u672c\u5e94\u7528\uff0c\u6ca1\u6709\u5f00\u542f\u5b9a\u65f6\u4efb\u52a1\u529f\u80fd\uff0c\u8bf7\u5728 conf.properties\u6587\u4ef6\u4e2d\u914d\u7f6e\u5f00\u542f", "base_fail");
        }
        JobKey jobKey = this.getJobKey(job);
        if (scheduler.checkExists(jobKey)) {
            scheduler.pauseJob(jobKey);
        }
        this.scheduleJobService.modifyStatus(job.getId(), ScheduleJob.JOB_STATE_PAUSE, Constant.NO_INT);
    }

    @Override
    public void resumeJob(ScheduleJob job) throws SchedulerException {
        Trigger trigger;
        if (!this.checkSwitch()) {
            throw new CommonException("\u672c\u5e94\u7528\uff0c\u6ca1\u6709\u5f00\u542f\u5b9a\u65f6\u4efb\u52a1\u529f\u80fd\uff0c\u8bf7\u5728 conf.properties\u6587\u4ef6\u4e2d\u914d\u7f6e\u5f00\u542f", "base_fail");
        }
        JobDetail jobDetail = null;
        if (this.checkExists(job)) {
            jobDetail = scheduler.getJobDetail(this.getJobKey(job));
            if (this.checkChange(jobDetail, job)) {
                this.deleteJob(job);
                jobDetail = this.addJob(job);
            }
        } else {
            jobDetail = this.addJob(job);
        }
        if (scheduler.checkExists((trigger = TriggerBuilder.newTrigger().withIdentity(job.getJobCode(), "DEFAULT").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)job.getCronExpression())).forJob(jobDetail).build()).getKey())) {
            scheduler.rescheduleJob(trigger.getKey(), trigger);
        } else {
            scheduler.scheduleJob(trigger);
        }
        this.scheduleJobService.modifyStatus(job.getId(), ScheduleJob.JOB_STATE_NORMAL, Constant.YES_INT);
    }

    public boolean checkExists(ScheduleJob job) throws SchedulerException {
        return scheduler.checkExists(this.getJobKey(job));
    }

    @Override
    public void deleteJob(ScheduleJob job) throws SchedulerException {
        if (!this.checkSwitch()) {
            throw new CommonException("\u672c\u5e94\u7528\uff0c\u6ca1\u6709\u5f00\u542f\u5b9a\u65f6\u4efb\u52a1\u529f\u80fd\uff0c\u8bf7\u5728 conf.properties\u6587\u4ef6\u4e2d\u914d\u7f6e\u5f00\u542f", "base_fail");
        }
        JobKey jobKey = this.getJobKey(job);
        if (scheduler.checkExists(jobKey)) {
            scheduler.deleteJob(jobKey);
        }
    }

    @Override
    public void updateJobCron(ScheduleJob job) throws SchedulerException {
        if (!this.checkSwitch()) {
            throw new CommonException("\u672c\u5e94\u7528\uff0c\u6ca1\u6709\u5f00\u542f\u5b9a\u65f6\u4efb\u52a1\u529f\u80fd\uff0c\u8bf7\u5728 conf.properties\u6587\u4ef6\u4e2d\u914d\u7f6e\u5f00\u542f", "base_fail");
        }
        scheduler.rescheduleJob(this.getTriggerKey(job), this.getTrigger(job));
    }

    @Override
    public List<ScheduleJob> getAllJob() throws SchedulerException {
        GroupMatcher matcher = GroupMatcher.anyJobGroup();
        Set jobKeys = scheduler.getJobKeys(matcher);
        ArrayList<ScheduleJob> allJobs = new ArrayList<ScheduleJob>();
        for (JobKey jobKey : jobKeys) {
            JobDetail jobDetail = scheduler.getJobDetail(jobKey);
            ScheduleJob job = (ScheduleJob)jobDetail.getJobDataMap().get((Object)JOB_PARAM_KEY);
            allJobs.add(job);
        }
        return allJobs;
    }

    @Override
    public List<ScheduleJob> getRunningJob() throws SchedulerException {
        List executingJobs = scheduler.getCurrentlyExecutingJobs();
        ArrayList<ScheduleJob> runningJobs = new ArrayList<ScheduleJob>();
        for (JobExecutionContext executingJob : executingJobs) {
            JobDetail jobDetail = executingJob.getJobDetail();
            ScheduleJob job = (ScheduleJob)jobDetail.getJobDataMap().get((Object)JOB_PARAM_KEY);
            runningJobs.add(job);
        }
        return runningJobs;
    }

    @Override
    public boolean isCronCorrect(String cronStr) {
        return CronExpression.isValidExpression((String)cronStr);
    }

    @PostConstruct
    protected void init() throws SchedulerException {
        if (!this.checkSwitch()) {
            return;
        }
        List<ScheduleJob> scheduleJobs = this.loadJobs();
        if (CollectionUtils.isEmpty(scheduleJobs)) {
            return;
        }
        for (ScheduleJob scheduleJob : scheduleJobs) {
            this.restartJob(scheduleJob);
        }
        scheduler.start();
        logger.info("INIT SCHEDULE JOBS SUCCESS");
    }

    @PreDestroy
    protected void destory() throws SchedulerException {
        scheduler.shutdown(false);
    }

    @Override
    public void restartJob(ScheduleJob job) {
        block3: {
            try {
                if (!Constant.YES_INT.equals(job.getIsEnable())) {
                    this.deleteJob(job);
                    return;
                }
                this.resumeJob(job);
                logger.info("Job register successed. jobCode : {} , jobName : {} , cron : {}", new Object[]{job.getJobCode(), job.getJobName(), job.getCronExpression()});
            }
            catch (Exception e) {
                String message = MessageFormat.format("Job register failed. jobCode : {0} , jobName{1} , cron:{2}", job.getJobCode(), job.getJobName(), job.getCronExpression());
                logger.error(message, (Throwable)e);
                if (job.getJobState().equals(ScheduleJob.JOB_STATE_EXCEPTION)) break block3;
                this.scheduleJobService.modifyStatus(job.getId(), ScheduleJob.JOB_STATE_EXCEPTION, null);
            }
        }
    }

    private boolean checkChange(JobDetail oldJobDetail, ScheduleJob job) throws SchedulerException {
        ScheduleJob oldJob = null;
        try {
            oldJob = (ScheduleJob)oldJobDetail.getJobDataMap().get((Object)JOB_PARAM_KEY);
        }
        catch (Exception e) {
            logger.warn("get jobDetail error", (Throwable)e);
        }
        if (oldJob == null) {
            return true;
        }
        return oldJob.getJobClass().equals(job.getJobClass()) && oldJob.getJobMethod().equals(job.getJobMethod()) && StringUtils.equals((String)oldJob.getJobMethodParams(), (String)job.getJobMethodParams());
    }

    public boolean checkSwitch() {
        return "true".equals(this.isJobEnalbe);
    }
}

