package com.els.base.schedule.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;

@ApiModel(value="定时任务执行历史")
public class ScheduleJobLog implements Serializable {
    @ApiModelProperty("定时任务Id")
    private String id;

    @ApiModelProperty("定时任务名称")
    private String jobName;

    @ApiModelProperty("job唯一代码")
    private String jobCode;

    @ApiModelProperty("定时任务描述")
    private String descriptopn;

    @ApiModelProperty("定时任务完整类名称")
    private String jobClass;

    @ApiModelProperty("定时任务方法名称")
    private String jobMethod;

    @ApiModelProperty("job状态,1正常运行，2运行异常")
    private Integer jobState;

    @ApiModelProperty("定时任务的Corn表达式")
    private String cronExpression;

    @ApiModelProperty("是否启用，1启用，0禁用")
    private Integer isEnable;

    @ApiModelProperty("能否并发运行，1可以，0不可以")
    private Integer isConcurrent;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("更新时间")
    private Date updateTime;

    @ApiModelProperty("定时任务方法参数")
    private String jobMethodParams;

    @ApiModelProperty("定时任务组")
    private String jobGroup;

    @ApiModelProperty("定时任务执行消耗的时间")
    private Long times;

    @ApiModelProperty("定时任务关联ID")
    private String jobId;

    @ApiModelProperty("实例名称")
    private String instanceName;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getJobName() {
        return jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName == null ? null : jobName.trim();
    }

    public String getJobCode() {
        return jobCode;
    }

    public void setJobCode(String jobCode) {
        this.jobCode = jobCode == null ? null : jobCode.trim();
    }

    public String getDescriptopn() {
        return descriptopn;
    }

    public void setDescriptopn(String descriptopn) {
        this.descriptopn = descriptopn == null ? null : descriptopn.trim();
    }

    public String getJobClass() {
        return jobClass;
    }

    public void setJobClass(String jobClass) {
        this.jobClass = jobClass == null ? null : jobClass.trim();
    }

    public String getJobMethod() {
        return jobMethod;
    }

    public void setJobMethod(String jobMethod) {
        this.jobMethod = jobMethod == null ? null : jobMethod.trim();
    }

    public Integer getJobState() {
        return jobState;
    }

    public void setJobState(Integer jobState) {
        this.jobState = jobState;
    }

    public String getCronExpression() {
        return cronExpression;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression == null ? null : cronExpression.trim();
    }

    public Integer getIsEnable() {
        return isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }

    public Integer getIsConcurrent() {
        return isConcurrent;
    }

    public void setIsConcurrent(Integer isConcurrent) {
        this.isConcurrent = isConcurrent;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getJobMethodParams() {
        return jobMethodParams;
    }

    public void setJobMethodParams(String jobMethodParams) {
        this.jobMethodParams = jobMethodParams == null ? null : jobMethodParams.trim();
    }

    public String getJobGroup() {
        return jobGroup;
    }

    public void setJobGroup(String jobGroup) {
        this.jobGroup = jobGroup == null ? null : jobGroup.trim();
    }

    public Long getTimes() {
        return times;
    }

    public void setTimes(Long times) {
        this.times = times;
    }

    public String getJobId() {
        return jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId == null ? null : jobId.trim();
    }

    public String getInstanceName() {
        return instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName == null ? null : instanceName.trim();
    }
}