/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.schedule.plugin;

import com.els.base.core.exception.CommonException;
import com.els.base.schedule.entity.ScheduleJob;
import com.els.base.schedule.entity.ScheduleJobLog;
import com.els.base.schedule.plugin.impl.QuartzManagerImpl;
import com.els.base.schedule.service.ScheduleJobLogService;
import com.els.base.schedule.utils.CommonInstanceIdGenerator;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.uuid.UUIDGenerator;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.BeanUtils;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;

@DisallowConcurrentExecution
@Component
public class DynamicJob
implements Job {
    private static final Logger logger = LoggerFactory.getLogger(DynamicJob.class);
    private static ScheduleJobLogService scheduleJobLogService;
    private static ThreadPoolTaskExecutor threadPoolTaskExecutor;

    public void execute(JobExecutionContext executorContext) throws JobExecutionException {
        String mdcId = UUID.randomUUID().toString().replaceAll("-", "");
        MDC.put((String)"mdc-uuid", (String)mdcId);
        JobDataMap map = executorContext.getMergedJobDataMap();
        ScheduleJob scheduleJob = (ScheduleJob)map.get((Object)QuartzManagerImpl.JOB_PARAM_KEY);
        long startTime = System.currentTimeMillis();
        logger.debug("EVENT=\u5f00\u59cb\u6267\u884c\u5b9a\u65f6\u4efb\u52a1|job={}|class={}|KEY={}", new Object[]{scheduleJob.getJobCode(), scheduleJob.getJobClass(), mdcId});
        try {
            this.runJobNow(scheduleJob);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException | SchedulerException e) {
            logger.error("\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5f02\u5e38", e);
            this.insertScheduleJobLog(scheduleJob, ScheduleJob.JOB_STATE_EXCEPTION, null);
            throw new CommonException("\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5f02\u5e38");
        }
        long times = System.currentTimeMillis() - startTime;
        logger.debug("EVENT=\u7ed3\u675f\u6267\u884c\u547d\u4ee4|COMMAND={}|class={}|KEY={}|COST={} ms", new Object[]{scheduleJob.getJobCode(), scheduleJob.getJobClass(), mdcId, times});
        this.insertScheduleJobLog(scheduleJob, ScheduleJob.JOB_STATE_NORMAL, times);
        MDC.remove((String)"mdc-uuid");
    }

    public void runJobNow(ScheduleJob scheduleJob) throws SchedulerException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        logger.info("Running Job : {} ", (Object)ToStringBuilder.reflectionToString((Object)scheduleJob, (ToStringStyle)ToStringStyle.DEFAULT_STYLE));
        ClassLoader classLoader = this.getClass().getClassLoader();
        Class<?> clazz = classLoader.loadClass(scheduleJob.getJobClass());
        Object excutionBean = SpringContextHolder.getOneBean(clazz);
        if (excutionBean == null) {
            throw new NullPointerException(String.format("spring context \u4e2d\u627e\u4e0d\u5230 class:%s", clazz.getName()));
        }
        String jobMethod = scheduleJob.getJobMethod();
        String jobMethodParams = scheduleJob.getJobMethodParams();
        if (StringUtils.isBlank((String)jobMethodParams)) {
            Method method = clazz.getDeclaredMethod(jobMethod, new Class[0]);
            ReflectionUtils.makeAccessible((Method)method);
            method.invoke(excutionBean, new Object[0]);
        } else {
            Method method = clazz.getDeclaredMethod(jobMethod, String.class);
            ReflectionUtils.makeAccessible((Method)method);
            method.invoke(excutionBean, jobMethodParams);
        }
    }

    private void insertScheduleJobLog(ScheduleJob scheduleJob, Integer jobState, Long times) {
        ScheduleJobLog scheduleJobLog = new ScheduleJobLog();
        BeanUtils.copyProperties((Object)scheduleJob, (Object)scheduleJobLog);
        scheduleJobLog.setId(UUIDGenerator.generateUUID());
        scheduleJobLog.setCreateTime(new Date());
        scheduleJobLog.setJobId(scheduleJob.getId());
        scheduleJobLog.setJobState(jobState);
        scheduleJobLog.setTimes(times);
        scheduleJobLog.setInstanceName(CommonInstanceIdGenerator.getDefaultInstanceId());
        DynamicJob.getThreadPoolTaskExecutor().execute(() -> DynamicJob.getScheduleJobLogService().addObj(scheduleJobLog));
    }

    private static ScheduleJobLogService getScheduleJobLogService() {
        if (scheduleJobLogService == null) {
            scheduleJobLogService = (ScheduleJobLogService)SpringContextHolder.getOneBean(ScheduleJobLogService.class);
        }
        return scheduleJobLogService;
    }

    private static ThreadPoolTaskExecutor getThreadPoolTaskExecutor() {
        if (threadPoolTaskExecutor == null) {
            threadPoolTaskExecutor = (ThreadPoolTaskExecutor)SpringContextHolder.getOneBean(ThreadPoolTaskExecutor.class);
        }
        return threadPoolTaskExecutor;
    }
}

