/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.schedule.utils;

import com.els.base.utils.SpringContextHolder;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import org.apache.commons.lang.time.DateFormatUtils;
import org.quartz.SchedulerException;
import org.quartz.spi.InstanceIdGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonInstanceIdGenerator
implements InstanceIdGenerator {
    private static final Logger logger = LoggerFactory.getLogger(CommonInstanceIdGenerator.class);

    public static String getDefaultInstanceId() {
        String instanceName = SpringContextHolder.getProperty((String)"server.display-name", (String)"");
        String port = SpringContextHolder.getProperty((String)"server.port");
        String hostIp = CommonInstanceIdGenerator.getLocalHost();
        String now = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss");
        instanceName = String.format("[%s:%s]%s-%s", hostIp, port, instanceName, now);
        return instanceName;
    }

    private static String getLocalHost() {
        String hostIp = null;
        try {
            InetAddress address = InetAddress.getLocalHost();
            hostIp = address.getHostAddress();
        }
        catch (UnknownHostException e) {
            logger.error("\u83b7\u53d6\u5f53\u524d\u7528\u6237IP\u5931\u8d25", (Throwable)e);
        }
        return hostIp;
    }

    public String generateInstanceId() throws SchedulerException {
        return CommonInstanceIdGenerator.getDefaultInstanceId();
    }
}

