package com.els.base.schedule.plugin;

import java.util.List;

import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;

import com.els.base.schedule.entity.ScheduleJob;

public interface QuartzManager {

	/**
	 * 任务调度参数key
	 *
	 * @param job
	 * @return
	 */
	public JobDataMap getJobDataMap(ScheduleJob job);

	/**
	 * 获取JobDataMap.(Job参数对象)
	 *
	 * @param job
	 * @return
	 */
	public JobDetail getJobDetail(ScheduleJob job);

	/**
	 * 获取JobDetail,JobDetail是任务的定义,而Job是任务的执行逻辑,JobDetail里会引用一个Job Class来定义
	 *
	 * @param job
	 * @return
	 */
	public Trigger getTrigger(ScheduleJob job);

	/**
	 * 获取JobKey,包含Name和Group
	 *
	 * @param job
	 * @return
	 */
	public JobKey getJobKey(ScheduleJob job);

	/**
	 * 获取TriggerKey,包含Name和Group
	 *
	 * @param job
	 * @return
	 */
	public TriggerKey getTriggerKey(ScheduleJob job);

	/**
	 * 重启所有的定时器
	 *
	 * @param job
	 * @throws SchedulerException
	 */
	public void restartJob(ScheduleJob jobs) throws SchedulerException;

	/**
	 * 添加一个定时任务到调度器里面
	 *
	 * @param job
	 * @param flag true 覆盖，不覆盖
	 * @return 
	 * @throws SchedulerException
	 */
	public JobDetail addJob(ScheduleJob job) throws SchedulerException;

	/**
	 * 立即执行 job
	 *
	 * @param job
	 * @throws SchedulerException
	 */
	public void runJobNow(ScheduleJob job) throws SchedulerException;

	/**
	 * 暂停 job
	 *
	 * @param job
	 * @throws SchedulerException
	 */
	public void pauseJob(ScheduleJob job) throws SchedulerException;

	/**
	 * 恢复运行job
	 *
	 * @param job
	 * @throws SchedulerException
	 */
	public void resumeJob(ScheduleJob job) throws SchedulerException;

	/**
	 * 删除job
	 *
	 * @param job
	 * @throws SchedulerException
	 */
	public void deleteJob(ScheduleJob job) throws SchedulerException;

	/**
	 * 更新 job 运行时间
	 *
	 * @param job
	 * @throws SchedulerException
	 */
	public void updateJobCron(ScheduleJob job) throws SchedulerException;

	/**
	 * 获取所有job
	 *
	 * @return
	 * @throws SchedulerException
	 */
	public List<ScheduleJob> getAllJob() throws SchedulerException;

	/**
	 * 获取所有在运行的job
	 *
	 * @return
	 * @throws SchedulerException
	 */
	public List<ScheduleJob> getRunningJob() throws SchedulerException;

	/**
	 * 时间表达式是否正确
	 *
	 * @param cronStr
	 * @return
	 */
	public boolean isCronCorrect(String cronStr);

	/**
	 * 判断bean在不在
	 * @param jobClass
	 * @return
	 */
//	public boolean isBeanExist(String jobClass);
}
