package com.els.base.schedule.utils;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;

import org.apache.commons.lang.time.DateFormatUtils;
import org.quartz.SchedulerException;
import org.quartz.spi.InstanceIdGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.els.base.utils.SpringContextHolder;

public class CommonInstanceIdGenerator implements InstanceIdGenerator {
	
	private static final Logger logger = LoggerFactory.getLogger(CommonInstanceIdGenerator.class);
	
	public static String getDefaultInstanceId(){
		String instanceName = SpringContextHolder.getProperty("server.display-name", "");
        String port = SpringContextHolder.getProperty("server.port");
        String hostIp = getLocalHost();
        String now = DateFormatUtils.format(new Date(), "yyyyMMddHHmmss");
        
        instanceName = String.format("[%s:%s]%s-%s", hostIp, port, instanceName, now);
        return instanceName;
	}
	
    private static String getLocalHost() {
    	String hostIp = null;
		try {
			InetAddress address = InetAddress.getLocalHost();
			hostIp = address.getHostAddress(); //返回IP地址
		} catch (UnknownHostException e) {
			logger.error("获取当前用户IP失败", e);
		}
    	return hostIp;
	}
	
	@Override
	public String generateInstanceId() throws SchedulerException {
		return getDefaultInstanceId();
	}

}
