/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.schedule.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.schedule.dao.ScheduleJobLogMapper;
import com.els.base.schedule.entity.ScheduleJobLog;
import com.els.base.schedule.entity.ScheduleJobLogExample;
import com.els.base.schedule.service.ScheduleJobLogService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultScheduleJobLogService")
public class ScheduleJobLogServiceImpl
implements ScheduleJobLogService {
    @Resource
    protected ScheduleJobLogMapper scheduleJobLogMapper;

    @CacheEvict(value={"scheduleJobLog"}, allEntries=true)
    public void addObj(ScheduleJobLog t) {
        this.scheduleJobLogMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"scheduleJobLog"}, allEntries=true)
    public void addAll(List<ScheduleJobLog> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.scheduleJobLogMapper.insertBatch(list);
    }

    @CacheEvict(value={"scheduleJobLog"}, allEntries=true)
    public void deleteObjById(String id) {
        this.scheduleJobLogMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"scheduleJobLog"}, allEntries=true)
    public void deleteByExample(ScheduleJobLogExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.scheduleJobLogMapper.deleteByExample(example);
    }

    @CacheEvict(value={"scheduleJobLog"}, allEntries=true)
    public void modifyObj(ScheduleJobLog t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.scheduleJobLogMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"scheduleJobLog"}, keyGenerator="redisKeyGenerator")
    public ScheduleJobLog queryObjById(String id) {
        return this.scheduleJobLogMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"scheduleJobLog"}, keyGenerator="redisKeyGenerator")
    public List<ScheduleJobLog> queryAllObjByExample(ScheduleJobLogExample example) {
        return this.scheduleJobLogMapper.selectByExample(example);
    }

    @Cacheable(value={"scheduleJobLog"}, keyGenerator="redisKeyGenerator")
    public PageView<ScheduleJobLog> queryObjByPage(ScheduleJobLogExample example) {
        PageView<ScheduleJobLog> pageView = example.getPageView();
        pageView.setQueryResult(this.scheduleJobLogMapper.selectByExampleByPage(example));
        return pageView;
    }
}

