/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.session.config;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.session.data.redis.RedisFlushMode;
import org.springframework.session.data.redis.RedisOperationsSessionRepository;
import org.springframework.session.data.redis.config.annotation.web.http.RedisHttpSessionConfiguration;

@ConditionalOnProperty(name={"http.session.redis.enable"}, havingValue="true", matchIfMissing=true)
@Configuration
public class SessionRedisConfiguration
extends RedisHttpSessionConfiguration {
    @Autowired
    @Qualifier(value="sessionRedisTemplate")
    private RedisTemplate<Object, Object> sessionRedisTemplate;
    @Autowired
    ApplicationEventPublisher applicationEventPublisher;
    @Value(value="${http.session.redis.timeout:1800}")
    int maxInactiveIntervalInSeconds;
    @Value(value="${http.session.redis.database:0}")
    protected String database;

    @Bean
    public RedisOperationsSessionRepository sessionRepository() {
        RedisOperationsSessionRepository sessionRepository = new RedisOperationsSessionRepository(this.sessionRedisTemplate);
        sessionRepository.setApplicationEventPublisher(this.applicationEventPublisher);
        sessionRepository.setDefaultSerializer((RedisSerializer)new JdkSerializationRedisSerializer());
        sessionRepository.setDefaultMaxInactiveInterval(this.maxInactiveIntervalInSeconds);
        sessionRepository.setRedisKeyNamespace("spring:session");
        sessionRepository.setRedisFlushMode(RedisFlushMode.ON_SAVE);
        if (!StringUtils.isNumeric((String)this.database) || Integer.valueOf(this.database) < 0) {
            throw new RuntimeException("\u914d\u7f6e http.session.redis.database \u53ea\u80fd\u662f\u6b63\u6574\u6570");
        }
        sessionRepository.setDatabase(Integer.valueOf(this.database).intValue());
        return sessionRepository;
    }
}

