/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.session;

import java.lang.reflect.Field;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.session.web.http.DefaultCookieSerializer;
import org.springframework.stereotype.Component;

@Component
public class McodingCookieSerializer
extends DefaultCookieSerializer {
    private boolean isSetdomainName = false;
    private boolean isSetDomainNamePattern = false;

    @Value(value="${http.session.cookie.path:/}")
    public void setCookiePath(String cookiePath) {
        super.setCookiePath(cookiePath);
    }

    @Value(value="${http.session.cookie.name:JSESSIONID}")
    public void setCookieName(String cookieName) {
        super.setCookieName(cookieName);
    }

    @Value(value="${http.session.cookie.domain.name:.empty_name}")
    public void setDomainName(String domainName) {
        if (".empty_name".equals(domainName)) {
            return;
        }
        if (this.isSetDomainNamePattern) {
            this.setDomainNamePatternAsNullForce();
        }
        this.isSetdomainName = true;
        super.setDomainName(domainName);
    }

    private void setDomainNamePatternAsNullForce() {
        try {
            Field field = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("domainNamePattern");
            field.setAccessible(true);
            field.set((Object)this, null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    @Value(value="${http.session.cookie.domain.pattern:(.*)}")
    public void setDomainNamePattern(String domainNamePattern) {
        if (this.isSetdomainName) {
            return;
        }
        this.isSetDomainNamePattern = true;
        super.setDomainNamePattern(domainNamePattern);
    }

    @Value(value="${http.session.cookie.maxage:-1}")
    public void setCookieMaxAge(int cookieMaxAge) {
        super.setCookieMaxAge(cookieMaxAge);
    }

    public static void main(String[] args) {
        McodingCookieSerializer serializer = new McodingCookieSerializer();
        serializer.setDomainNamePattern("abac");
        serializer.setDomainName("tee");
    }
}

