package com.els.base.session;

import java.lang.reflect.Field;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.session.web.http.DefaultCookieSerializer;
import org.springframework.stereotype.Component;

@Component
public class McodingCookieSerializer extends DefaultCookieSerializer {
	
	private boolean isSetdomainName = false;
	private boolean isSetDomainNamePattern = false;
	
	@Value("${http.session.cookie.path:/}")
	@Override
	public void setCookiePath(String cookiePath) {
		super.setCookiePath(cookiePath);
	}

	@Value("${http.session.cookie.name:JSESSIONID}")
	@Override
	public void setCookieName(String cookieName) {
		super.setCookieName(cookieName);
	}
	
	@Value("${http.session.cookie.domain.name:.empty_name}")
	@Override
	public void setDomainName(String domainName) {
		if (".empty_name".equals(domainName)) {
			return;
		}
		if (this.isSetDomainNamePattern) {
			this.setDomainNamePatternAsNullForce();
		}
		
		this.isSetdomainName = true;
		super.setDomainName(domainName);
	}

	/**
	 * 使用反射的方式强制把 domainNamePattern 设置为空
	 */
	private void setDomainNamePatternAsNullForce() {
		try {
			Field field = this.getClass().getSuperclass().getDeclaredField("domainNamePattern");
			field.setAccessible(true);
			field.set(this, null);
		} catch (NoSuchFieldException | SecurityException | IllegalArgumentException | IllegalAccessException e) {
			throw new RuntimeException(e);
		}
	}

	@Value("${http.session.cookie.domain.pattern:(.*)}")
	@Override
	public void setDomainNamePattern(String domainNamePattern) {
		if (isSetdomainName) {
			return;
		}
		this.isSetDomainNamePattern = true;
		super.setDomainNamePattern(domainNamePattern);
	}

	@Value("${http.session.cookie.maxage:-1}")
	@Override
	public void setCookieMaxAge(int cookieMaxAge) {
		super.setCookieMaxAge(cookieMaxAge);
	}

	/*@Override
	public void writeCookieValue(CookieValue cookieValue) {
		HttpServletRequest request = cookieValue.getRequest();
		String domain = request.getServerName();
		if (domain.contains("localhost") || domain.contains("127.0.0.1")) {
			this.setDomainName(domain);
		}
		
		super.writeCookieValue(cookieValue);
		
	}*/

	public static void main(String[] args) {
		McodingCookieSerializer serializer = new McodingCookieSerializer();
		serializer.setDomainNamePattern("abac");
		serializer.setDomainName("tee");
		
	}
}
