/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.session.config;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.session.ExpiringSession;
import org.springframework.session.SessionRepository;
import org.springframework.session.data.redis.RedisOperationsSessionRepository;
import org.springframework.session.data.redis.config.annotation.web.http.RedisHttpSessionConfiguration;
import org.springframework.session.web.http.SessionEventHttpSessionListenerAdapter;
import org.springframework.session.web.http.SessionRepositoryFilter;
import redis.clients.jedis.JedisPoolConfig;

@ConditionalOnProperty(name={"http.session.redis.enable"}, havingValue="true", matchIfMissing=true)
@Configuration
public class SessionRedisConfiguration
extends RedisHttpSessionConfiguration {
    private static Logger logger = LoggerFactory.getLogger(SessionRedisConfiguration.class);
    private static final String DEFALUT_NO_PASSWORD = "_default_empty";
    @Value(value="${http.session.redis.pool.maxTotal:50}")
    protected String maxTotal;
    @Value(value="${http.session.redis.pool.maxIdle:10}")
    protected String maxIdle;
    @Value(value="${http.session.redis.pool.maxWaitMillis:300000}")
    protected String maxWaitMillis;
    @Value(value="${http.session.redis.pool.testOnBorrow:true}")
    protected String testOnBorrow;
    @Value(value="${http.session.redis.hostname}")
    protected String hostName;
    @Value(value="${http.session.redis.port}")
    protected String port;
    @Value(value="${http.session.redis.password:_default_empty}")
    protected String password;
    @Value(value="${http.session.redis.database:0}")
    protected String database;
    @Value(value="${http.session.redis.cluster.is.enable:false}")
    protected String isCluster;
    @Value(value="${http.session.redis.cluster.nodes:false}")
    protected String nodes;

    @Value(value="${http.session.redis.timeout:1800}")
    public void setMaxInactiveIntervalInSeconds(int maxInactiveIntervalInSeconds) {
        super.setMaxInactiveIntervalInSeconds(maxInactiveIntervalInSeconds);
    }

    @Bean(value={"httpSessionRedisConfig"})
    public JedisPoolConfig getJedisPoolConfig() {
        JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
        jedisPoolConfig.setMaxTotal(Integer.valueOf(this.maxTotal).intValue());
        jedisPoolConfig.setMaxIdle(Integer.valueOf(this.maxIdle).intValue());
        jedisPoolConfig.setMaxWaitMillis(Long.valueOf(this.maxWaitMillis).longValue());
        jedisPoolConfig.setTestOnBorrow(Boolean.valueOf(this.testOnBorrow).booleanValue());
        return jedisPoolConfig;
    }

    @Bean(value={"sessionRedisConnectionFactory"})
    public JedisConnectionFactory getJedisConnectionFactory() {
        if ("true".equals(this.isCluster.trim().toLowerCase())) {
            RedisClusterConfiguration clusterConfig = this.getClusterConfig();
            JedisConnectionFactory connectionFactory = new JedisConnectionFactory(clusterConfig);
            connectionFactory.setPoolConfig(this.getJedisPoolConfig());
            if (StringUtils.isNotBlank((String)this.password) && !DEFALUT_NO_PASSWORD.equals(this.password)) {
                connectionFactory.setPassword(this.password);
            }
            return connectionFactory;
        }
        Assert.isNotBlank((String)this.hostName, (String)"\u914d\u7f6e http.session.redis.hostname \u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)this.port, (String)"\u914d\u7f6e http.session.redis.port \u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)this.password, (String)"\u914d\u7f6e http.session.redis.password \u4e0d\u80fd\u4e3a\u7a7a");
        if (!StringUtils.isNumeric((String)this.database)) {
            throw new CommonException("\u914d\u7f6e http.session.redis.database\uff0c \u662f\u4e00\u4e2a\u6574\u6570");
        }
        logger.info("session redis config server[{}:{}] pass[{}]", new Object[]{this.hostName, this.port, this.centerPad(this.password)});
        JedisConnectionFactory connectionFactory = new JedisConnectionFactory();
        connectionFactory.setPoolConfig(this.getJedisPoolConfig());
        connectionFactory.setHostName(this.hostName);
        connectionFactory.setPort(Integer.valueOf(this.port).intValue());
        if (StringUtils.isNotBlank((String)this.password) && !DEFALUT_NO_PASSWORD.equals(this.password)) {
            connectionFactory.setPassword(this.password);
        }
        connectionFactory.setDatabase(Integer.valueOf(this.database).intValue());
        return connectionFactory;
    }

    private RedisClusterConfiguration getClusterConfig() {
        Assert.isNotBlank((String)this.nodes, (String)"\u914d\u7f6e http.session.redis.cluster.nodes \u4e0d\u80fd\u4e3a\u7a7a");
        String[] nodeArray = this.nodes.split(";");
        HashSet<String> nodeSet = new HashSet<String>();
        for (String node : nodeArray) {
            String[] ipAndPort = node.split(":");
            if (ipAndPort.length != 2) {
                throw new CommonException(String.format("http.session.redis.cluster.nodes \u96c6\u7fa4\u4e2d\uff0cip\u4e0e\u7aef\u53e3\u7684\u914d\u7f6e\u9519\u8bef: {%s}", node));
            }
            if (!StringUtils.isNumeric((String)ipAndPort[1])) {
                throw new CommonException(String.format("http.session.redis.cluster.nodes \u96c6\u7fa4\u4e2d\uff0cip\u4e0e\u7aef\u53e3\u7684\u914d\u7f6e\u9519\u8bef: {%s}", node));
            }
            if (!ipAndPort[0].matches("[a-zA-Z0-9][-a-zA-Z0-9]{0,62}(.[a-zA-Z0-9][-a-zA-Z0-9]{0,62})+.?")) {
                throw new CommonException(String.format("\u96c6\u7fa4\u4e2d\uff0cip\u4e0e\u7aef\u53e3\u7684\u914d\u7f6e\u9519\u8bef: {%s}", node));
            }
            nodeSet.add(node);
        }
        RedisClusterConfiguration clusterConfiguration = new RedisClusterConfiguration(nodeSet);
        return clusterConfiguration;
    }

    @Bean(value={"sessionRedisTemplate"})
    public RedisTemplate<?, ?> getRedisTemplate() {
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory((RedisConnectionFactory)this.getJedisConnectionFactory());
        return template;
    }

    @Bean(value={"sessionRedisListener"})
    public SessionEventHttpSessionListenerAdapter getListener() {
        SessionEventHttpSessionListenerAdapter listener = new SessionEventHttpSessionListenerAdapter(new ArrayList());
        return listener;
    }

    @Bean(value={"sessionRepository"})
    public RedisOperationsSessionRepository getSessionRepository() {
        RedisOperationsSessionRepository repository = new RedisOperationsSessionRepository((RedisConnectionFactory)this.getJedisConnectionFactory());
        return repository;
    }

    public RedisTemplate<Object, Object> sessionRedisTemplate(@Qualifier(value="sessionRedisConnectionFactory") RedisConnectionFactory connectionFactory) {
        return super.sessionRedisTemplate((RedisConnectionFactory)this.getJedisConnectionFactory());
    }

    public RedisMessageListenerContainer redisMessageListenerContainer(@Qualifier(value="sessionRedisConnectionFactory") RedisConnectionFactory connectionFactory, @Qualifier(value="sessionRepository") RedisOperationsSessionRepository messageListener) {
        return super.redisMessageListenerContainer(connectionFactory, messageListener);
    }

    public InitializingBean enableRedisKeyspaceNotificationsInitializer(@Qualifier(value="sessionRedisConnectionFactory") RedisConnectionFactory connectionFactory) {
        return super.enableRedisKeyspaceNotificationsInitializer(connectionFactory);
    }

    public <S extends ExpiringSession> SessionRepositoryFilter<? extends ExpiringSession> springSessionRepositoryFilter(@Qualifier(value="sessionRepository") SessionRepository<S> sessionRepository) {
        return super.springSessionRepositoryFilter(sessionRepository);
    }

    public RedisOperationsSessionRepository sessionRepository(@Qualifier(value="sessionRedisTemplate") RedisOperations<Object, Object> sessionRedisTemplate, @Qualifier(value="sessionRedisListener") ApplicationEventPublisher applicationEventPublisher) {
        return super.sessionRepository(sessionRedisTemplate, applicationEventPublisher);
    }

    private String centerPad(String password) {
        if (password.length() <= 2) {
            return password;
        }
        return password.substring(0, 1) + StringUtils.leftPad((String)password.substring(password.length() - 1), (int)(password.length() - 1), (String)"*");
    }
}

