/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.session.config;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisConfiguration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.session.data.redis.config.annotation.SpringSessionRedisConnectionFactory;

@ConditionalOnProperty(name={"http.session.redis.enable"}, havingValue="true", matchIfMissing=true)
@Configuration
public class RedisClientConfig {
    private static final String DEFALUT_NO_PASSWORD = "_default_empty";
    @Value(value="${http.session.redis.pool.maxTotal:50}")
    protected String maxTotal;
    @Value(value="${http.session.redis.pool.maxIdle:10}")
    protected String maxIdle;
    @Value(value="${http.session.redis.pool.maxWaitMillis:300000}")
    protected String maxWaitMillis;
    @Value(value="${http.session.redis.pool.testOnBorrow:true}")
    protected String testOnBorrow;
    @Value(value="${http.session.redis.hostname}")
    protected String hostName;
    @Value(value="${http.session.redis.port}")
    protected String port;
    @Value(value="${http.session.redis.password:_default_empty}")
    protected String password;
    @Value(value="${http.session.redis.database:0}")
    protected String database;
    @Value(value="${http.session.redis.cluster.is.enable:false}")
    protected String isCluster;
    @Value(value="${http.session.redis.cluster.nodes:false}")
    protected String nodes;

    @SpringSessionRedisConnectionFactory
    @Bean(value={"springSessionRedisConnectionFactory"})
    public LettuceConnectionFactory sessionRedisConnectionFactory() {
        Object config = null;
        config = !"true".equalsIgnoreCase(this.isCluster.trim()) ? this.getStandaloneConfiguration() : this.getClusterConfig();
        return new LettuceConnectionFactory(config);
    }

    private RedisConfiguration getStandaloneConfiguration() {
        Assert.isNotBlank((String)this.hostName, (String)"\u914d\u7f6e http.session.redis.hostname \u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)this.port, (String)"\u914d\u7f6e http.session.redis.port \u4e0d\u80fd\u4e3a\u7a7a");
        if (!StringUtils.isNumeric((String)this.port) || Integer.valueOf(this.port) <= 0) {
            throw new RuntimeException("\u914d\u7f6e http.session.redis.port \u53ea\u80fd\u662f\u6b63\u6574\u6570");
        }
        if (!StringUtils.isNumeric((String)this.database) || Integer.valueOf(this.database) < 0) {
            throw new RuntimeException("\u914d\u7f6e http.session.redis.database \u53ea\u80fd\u662f\u6b63\u6574\u6570");
        }
        RedisStandaloneConfiguration config = new RedisStandaloneConfiguration(this.hostName, Integer.valueOf(this.port).intValue());
        config.setDatabase(Integer.valueOf(this.database).intValue());
        if (StringUtils.isNotBlank((String)this.password) && !DEFALUT_NO_PASSWORD.equals(this.password)) {
            config.setPassword(this.password);
        }
        return config;
    }

    private RedisClusterConfiguration getClusterConfig() {
        Assert.isNotBlank((String)this.nodes, (String)"\u914d\u7f6ehttp.session.redis.cluster.nodes \u4e0d\u80fd\u4e3a\u7a7a");
        String[] nodeArray = this.nodes.split(";");
        HashSet<String> nodeSet = new HashSet<String>();
        for (String node : nodeArray) {
            String[] ipAndPort = node.split(":");
            if (ipAndPort.length != 2) {
                throw new CommonException(String.format("\u96c6\u7fa4\u4e2d\uff0cip\u4e0e\u7aef\u53e3\u7684\u914d\u7f6e\u9519\u8bef: {%s}", node));
            }
            if (!StringUtils.isNumeric((String)ipAndPort[1])) {
                throw new CommonException(String.format("\u96c6\u7fa4\u4e2d\uff0cip\u4e0e\u7aef\u53e3\u7684\u914d\u7f6e\u9519\u8bef: {%s}", node));
            }
            if (!ipAndPort[0].matches("[a-zA-Z0-9][-a-zA-Z0-9]{0,62}(.[a-zA-Z0-9][-a-zA-Z0-9]{0,62})+.?")) {
                throw new CommonException(String.format("\u96c6\u7fa4\u4e2d\uff0cip\u4e0e\u7aef\u53e3\u7684\u914d\u7f6e\u9519\u8bef: {%s}", node));
            }
            nodeSet.add(node);
        }
        RedisClusterConfiguration clusterConfiguration = new RedisClusterConfiguration(nodeSet);
        if (StringUtils.isNotBlank((String)this.password) && !DEFALUT_NO_PASSWORD.equals(this.password)) {
            clusterConfiguration.setPassword(this.password);
        }
        return clusterConfiguration;
    }

    @Bean(value={"sessionRedisTemplate"})
    public RedisTemplate<Object, Object> sessionRedisTemplate(@Qualifier(value="springSessionRedisConnectionFactory") RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate sessionRedisTemplate = new RedisTemplate();
        sessionRedisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        sessionRedisTemplate.setConnectionFactory(redisConnectionFactory);
        return sessionRedisTemplate;
    }
}

