/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.template.center.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.template.center.dao.TemplateCenterMapper;
import com.els.base.template.center.entity.TemplateCenter;
import com.els.base.template.center.entity.TemplateCenterExample;
import com.els.base.template.center.service.TemplateCenterService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultTemplateCenterService")
public class TemplateCenterServiceImpl
implements TemplateCenterService {
    @Resource
    protected TemplateCenterMapper templateCenterMapper;

    @Override
    @Cacheable(value={"templateCenter"}, keyGenerator="redisKeyGenerator")
    public int countByExample(TemplateCenterExample example) {
        return this.templateCenterMapper.countByExample(example);
    }

    @Override
    @Cacheable(value={"templateCenter"}, keyGenerator="redisKeyGenerator")
    public TemplateCenter queryObjByTemplateNo(String templateNo) {
        TemplateCenterExample example = new TemplateCenterExample();
        example.createCriteria().andTemplateNoEqualTo(templateNo).andIsEnableEqualTo(Constant.YES_INT);
        List<TemplateCenter> templateCenters = this.templateCenterMapper.selectByExampleWithBLOBs(example);
        TemplateCenter templateCenter = new TemplateCenter();
        if (CollectionUtils.isNotEmpty(templateCenters)) {
            templateCenter = templateCenters.get(0);
        }
        return templateCenter;
    }

    @CacheEvict(value={"templateCenter"}, allEntries=true)
    public void addObj(TemplateCenter t) {
        this.templateCenterMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"templateCenter"}, allEntries=true)
    public void addAll(List<TemplateCenter> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.templateCenterMapper.insertBatch(list);
    }

    @CacheEvict(value={"templateCenter"}, allEntries=true)
    public void deleteObjById(String id) {
        this.templateCenterMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"templateCenter"}, allEntries=true)
    public void deleteByExample(TemplateCenterExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.templateCenterMapper.deleteByExample(example);
    }

    @CacheEvict(value={"templateCenter"}, allEntries=true)
    public void modifyObj(TemplateCenter t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.templateCenterMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"templateCenter"}, keyGenerator="redisKeyGenerator")
    public TemplateCenter queryObjById(String id) {
        return this.templateCenterMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"templateCenter"}, keyGenerator="redisKeyGenerator")
    public List<TemplateCenter> queryAllObjByExample(TemplateCenterExample example) {
        return this.templateCenterMapper.selectByExample(example);
    }

    @Cacheable(value={"templateCenter"}, keyGenerator="redisKeyGenerator")
    public PageView<TemplateCenter> queryObjByPage(TemplateCenterExample example) {
        PageView<TemplateCenter> pageView = example.getPageView();
        pageView.setQueryResult(this.templateCenterMapper.selectByExampleByPage(example));
        return pageView;
    }
}

