/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.test;

import com.els.base.utils.json.JsonUtils;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultHandlers;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

@RunWith(value=SpringRunner.class)
public class BaseTest<T> {
    private static Logger logger = LoggerFactory.getLogger(BaseTest.class);
    private static MockMvc mockMvc;
    protected static String id;
    @Autowired
    protected WebApplicationContext webContext;

    protected MockMvc getMockMvc() {
        return mockMvc;
    }

    @Before
    public void initMockMvc() {
        if (mockMvc != null) {
            return;
        }
        logger.info("start initMockMvc ......");
        mockMvc = MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.webContext).build();
        logger.info("end initMockMvc ......");
    }

    @Test
    public void test00InitMock() {
        logger.info("test00InitMock ......");
    }

    protected ResultActions post(String url, Object t) throws Exception {
        MockHttpServletRequestBuilder request = MockMvcRequestBuilders.post((String)url, (Object[])new Object[0]).contentType(MediaType.APPLICATION_JSON).content(JsonUtils.writeValueAsString((Object)t));
        ResultActions result = this.getMockMvc().perform((RequestBuilder)request);
        result.andDo(MockMvcResultHandlers.print());
        result.andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"code", (Object[])new Object[0]).value((Object)"200"));
        return result;
    }

    protected ResultActions get(String url) throws Exception {
        MockHttpServletRequestBuilder request = MockMvcRequestBuilders.get((String)url, (Object[])new Object[0]);
        ResultActions result = this.getMockMvc().perform((RequestBuilder)request);
        result.andDo(MockMvcResultHandlers.print());
        result.andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"code", (Object[])new Object[0]).value((Object)"200"));
        return result;
    }

    protected ResultActions findByPage(String url, String id) throws Exception {
        MockHttpServletRequestBuilder request = MockMvcRequestBuilders.post((String)url, (Object[])new Object[0]).param("pageNo", new String[]{"1"}).param("pageSize", new String[]{"10"}).contentType(MediaType.APPLICATION_JSON);
        if (StringUtils.isNotBlank((String)id)) {
            HashMap<String, String> queryWapper = new HashMap<String, String>();
            queryWapper.put("id_$_eq", id);
            request.content(JsonUtils.writeValueAsString(queryWapper));
        }
        ResultActions actions = this.getMockMvc().perform((RequestBuilder)request);
        ResultActions result = actions.andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"code", (Object[])new Object[0]).value((Object)"200")).andExpect(MockMvcResultMatchers.jsonPath((String)"data.queryResult", (Object[])new Object[0]).exists());
        return result;
    }

    protected ResultActions create(String url, T t) throws Exception {
        Assert.assertNotNull((String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", t);
        ResultActions result = this.post(url, t);
        result.andExpect(MockMvcResultMatchers.jsonPath((String)"data", (Object[])new Object[0]).isNotEmpty());
        return result;
    }

    protected ResultActions edit(String url, T t) throws Exception {
        Assert.assertNotNull((String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", t);
        ResultActions result = this.post(url, t);
        return result;
    }

    protected ResultActions deleteByIds(String url, List<String> ids) throws Exception {
        MockHttpServletRequestBuilder request = MockMvcRequestBuilders.post((String)url, (Object[])new Object[0]).contentType(MediaType.APPLICATION_JSON).content(JsonUtils.writeValueAsString(ids));
        return this.getMockMvc().perform((RequestBuilder)request).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"code", (Object[])new Object[0]).value((Object)"200"));
    }

    protected ResultActions findByPage(String url) throws Exception {
        return this.findByPage(url, null);
    }
}

