package com.els.base.test;


import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.test.web.servlet.request.SecurityMockMvcRequestPostProcessors;
import org.springframework.security.test.web.servlet.setup.SecurityMockMvcConfigurers;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.test.web.servlet.result.MockMvcResultHandlers;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

import com.els.base.utils.json.JsonUtils;

@RunWith(SpringRunner.class)
public abstract class BaseTestWithUser<T> {

	private static Logger logger = LoggerFactory.getLogger(BaseTestWithUser.class);
	private static MockMvc mockMvc;
	
	protected static String id;
	
	@Autowired
    protected WebApplicationContext webContext;   //注入WebApplicationContext
	
	
    protected MockMvc getMockMvc() {
        return mockMvc;
    }
    
    @Before
    public void initMockMvc(){
    	if (mockMvc != null) {
    		return;
    	}
    	 //设置MockMvc
    	logger.info("start initMockMvc ......");
        mockMvc = MockMvcBuilders
	        .webAppContextSetup(webContext)
	        .apply(SecurityMockMvcConfigurers.springSecurity())
	        .build();
        logger.info("end initMockMvc ......");
    }
    
    @Test
	public void test00InitMock() {
		logger.info("test00InitMock ......");
	}

	/**
	 * 查询数据
	 * @param id
	 * @throws Exception
	 */
	protected ResultActions findByPage(String url, String id) throws Exception{

		MockHttpServletRequestBuilder request = MockMvcRequestBuilders.post(url)
			.param("pageNo","1").param("pageSize","10")
			.contentType(MediaType.APPLICATION_JSON)
			.with(this.getUser());
		
		if (StringUtils.isNotBlank(id)) {
			Map<String, String> queryWapper = new HashMap<>();
			queryWapper.put("id_$_eq", id);
			request.content(JsonUtils.writeValueAsString(queryWapper));
		}
		
		ResultActions actions = getMockMvc().perform(request);
		actions.andDo(MockMvcResultHandlers.print());
		
		ResultActions result = actions.andExpect(MockMvcResultMatchers.status().isOk())
			.andExpect(MockMvcResultMatchers.jsonPath("code").value("200"))
			.andExpect(MockMvcResultMatchers.jsonPath("data.queryResult").exists());
		
		return result;
	}
	
	protected ResultActions create(String url, T t) throws Exception {
		Assert.assertNotNull("数据不能为空", t);
		
		MockHttpServletRequestBuilder request = MockMvcRequestBuilders.post(url)
			.contentType(MediaType.APPLICATION_JSON)
			.content(JsonUtils.writeValueAsString(t))
			.with(this.getUser());
		
		ResultActions result = getMockMvc().perform(request)
//			.andDo(handler)
			.andExpect(MockMvcResultMatchers.status().isOk())
			.andExpect(MockMvcResultMatchers.jsonPath("code").value("200"))
			.andExpect(MockMvcResultMatchers.jsonPath("data").isNotEmpty());
		
		return result;
	}
	
	private RequestPostProcessor getUser() {
		return SecurityMockMvcRequestPostProcessors.user(this.getUserDetail());
	}

	/**
	 * 返回指定的 操作帐号
	 * @return
	 */
	protected abstract UserDetails getUserDetail() ;

	protected ResultActions edit(String url, T t) throws Exception {
		Assert.assertNotNull("数据不能为空", t);
		
		MockHttpServletRequestBuilder request = MockMvcRequestBuilders.post(url)
				.contentType(MediaType.APPLICATION_JSON)
				.content(JsonUtils.writeValueAsString(t))
				.with(this.getUser());
			
		ResultActions result = getMockMvc().perform(request)
			.andExpect(MockMvcResultMatchers.status().isOk())
			.andExpect(MockMvcResultMatchers.jsonPath("code").value("200"));
		
		return result;
	}
	
	protected ResultActions deleteByIds(String url, List<String> ids) throws Exception {
		MockHttpServletRequestBuilder request = MockMvcRequestBuilders.post(url)
				.contentType(MediaType.APPLICATION_JSON)
				.content(JsonUtils.writeValueAsString(ids))
				.with(this.getUser());
		
		return getMockMvc().perform(request)
			.andExpect(MockMvcResultMatchers.status().isOk())
			.andExpect(MockMvcResultMatchers.jsonPath("code").value("200"));
	}
	
	protected ResultActions findByPage(String url) throws Exception{
		return this.findByPage(url, null);
	}
}
