-- ----------------------------
-- 用户个性化默认设置
-- ----------------------------
-- DROP TABLE "T_BASE_DEFAULT_PROFILE";
CREATE TABLE "T_BASE_DEFAULT_PROFILE"
(
    "ID"            NVARCHAR2(32) NOT NULL,
    "PROFILE_TYPE"  NUMBER(11),
    "NAME"          NCLOB,
    "DEFAULT_VALUE" NCLOB,
    "CODE"          NVARCHAR2(256),
    "SORT"          NUMBER(11)
);

COMMENT ON COLUMN "T_BASE_DEFAULT_PROFILE"."ID" IS '表的主键';
COMMENT ON COLUMN "T_BASE_DEFAULT_PROFILE"."PROFILE_TYPE" IS '配置的类型：1单选，2多选';
COMMENT ON COLUMN "T_BASE_DEFAULT_PROFILE"."NAME" IS '配置项的名称';
COMMENT ON COLUMN "T_BASE_DEFAULT_PROFILE"."DEFAULT_VALUE" IS '配置项的默认设置';
COMMENT ON COLUMN "T_BASE_DEFAULT_PROFILE"."CODE" IS '设置项的CODE值';
COMMENT ON COLUMN "T_BASE_DEFAULT_PROFILE"."SORT" IS '设置项的顺序';
COMMENT ON TABLE "T_BASE_DEFAULT_PROFILE" IS '用户个性化默认设置';

ALTER TABLE "T_BASE_DEFAULT_PROFILE"
    ADD PRIMARY KEY ("ID");


-- ----------------------------
-- 用户设置配置选项值
-- ----------------------------
-- DROP TABLE "T_BASE_USER_PROFILE";
CREATE TABLE "T_BASE_USER_PROFILE"
(
    "ID"         NVARCHAR2(32) NOT NULL,
    "USER_ID"    NVARCHAR2(32),
    "PROFILE_ID" NVARCHAR2(32),
    "OPTION_VAL" NVARCHAR2(128),
    "PLATFORM"   NVARCHAR2(16)
);

COMMENT ON COLUMN "T_BASE_USER_PROFILE"."ID" IS '表的主键ID';
COMMENT ON COLUMN "T_BASE_USER_PROFILE"."USER_ID" IS '用户表主键ID';
COMMENT ON COLUMN "T_BASE_USER_PROFILE"."PROFILE_ID" IS '配置表主键ID';
COMMENT ON COLUMN "T_BASE_USER_PROFILE"."OPTION_VAL" IS '用户设置的配置选项值';
COMMENT ON COLUMN "T_BASE_USER_PROFILE"."PLATFORM" IS '用户设置配置选项值对应的平台';


ALTER TABLE "T_BASE_USER_PROFILE"
    ADD PRIMARY KEY ("ID");


-- ----------------------------
-- 用户个性化设置
-- ----------------------------
-- DROP TABLE "T_BASE_PROFILE_OPTION";
CREATE TABLE "T_BASE_PROFILE_OPTION"
(
    "ID"         NVARCHAR2(32) NOT NULL,
    "PROFILE_ID" NVARCHAR2(32),
    "NAME"       NCLOB,
    "VAL"        NVARCHAR2(128),
    "SORT"       NUMBER(11)
);

COMMENT ON COLUMN "T_BASE_PROFILE_OPTION"."ID" IS '表主键ID';
COMMENT ON COLUMN "T_BASE_PROFILE_OPTION"."PROFILE_ID" IS '配置主表ID';
COMMENT ON COLUMN "T_BASE_PROFILE_OPTION"."NAME" IS '配置选项名称';
COMMENT ON COLUMN "T_BASE_PROFILE_OPTION"."VAL" IS '配置选项值';
COMMENT ON COLUMN "T_BASE_PROFILE_OPTION"."SORT" IS '选项的顺序';
COMMENT ON TABLE "T_BASE_PROFILE_OPTION" IS '选项的顺序';

ALTER TABLE "T_BASE_PROFILE_OPTION"
    ADD PRIMARY KEY ("ID");


-- ----------------------------
-- 用户列自定义
-- ----------------------------
-- DROP TABLE "T_BASE_USER_COLUMN_DEFINED";
CREATE TABLE "T_BASE_USER_COLUMN_DEFINED"
(
    "ID"                   NVARCHAR2(32) NOT NULL,
    "PROJECT_ID"           NVARCHAR2(32),
    "USER_ID"              NVARCHAR2(32),
    "COLUMN_DEFINED_VALUE" NCLOB,
    "IS_DEFALUT"           NUMBER(11),
    "CREATE_TIME"          DATE,
    "COLUMN_VALUE"         NCLOB,
    "MODEL_CODE"           VARCHAR2(1000 BYTE)
);

COMMENT ON COLUMN "T_BASE_USER_COLUMN_DEFINED"."USER_ID" IS '用户id';
COMMENT ON COLUMN "T_BASE_USER_COLUMN_DEFINED"."COLUMN_DEFINED_VALUE" IS '自定义列顺序,字段名$字段code$宽度，字段名$字段code$宽度';
COMMENT ON COLUMN "T_BASE_USER_COLUMN_DEFINED"."IS_DEFALUT" IS '默认列,0：默认，1：不默认';
COMMENT ON COLUMN "T_BASE_USER_COLUMN_DEFINED"."MODEL_CODE" IS '模块编码';
COMMENT ON TABLE "T_BASE_USER_COLUMN_DEFINED" IS '用户列自定义';

ALTER TABLE "T_BASE_USER_COLUMN_DEFINED"
    ADD PRIMARY KEY ("ID");
