/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.userprofile.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.userprofile.entity.UserColumnDefined;
import com.els.base.userprofile.entity.UserColumnDefinedExample;
import com.els.base.userprofile.service.UserColumnDefinedService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u7528\u6237\u5217\u81ea\u5b9a\u4e49")
@Controller
@RequestMapping(value={"userColumnDefined"})
public class UserColumnDefinedController {
    @Resource
    protected UserColumnDefinedService userColumnDefinedService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u81ea\u5b9a\u4e49")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody UserColumnDefined userColumnDefined) {
        String userId = SpringSecurityUtils.getLoginUserId();
        String projectId = ProjectUtils.getProjectId();
        UserColumnDefinedExample example = new UserColumnDefinedExample();
        UserColumnDefinedExample.Criteria criteria = example.createCriteria();
        criteria.andUserIdEqualTo(userId);
        criteria.andProjectIdEqualTo(projectId);
        criteria.andModelCodeEqualTo(userColumnDefined.getModelCode());
        List list = this.userColumnDefinedService.queryAllObjByExample((IExample)example);
        if (list.size() != 0) {
            userColumnDefined.setId(((UserColumnDefined)list.get(0)).getId());
            this.userColumnDefinedService.modifyObj(userColumnDefined);
        } else {
            userColumnDefined.setUserId(userId);
            userColumnDefined.setProjectId(projectId);
            this.userColumnDefinedService.addObj(userColumnDefined);
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="GET", value="\u67e5\u8be2\u7528\u6237\u4e0b\u6a21\u5757\u7684\u81ea\u5b9a\u4e49")
    @RequestMapping(value={"service/findByUserIdModelCode"})
    @ResponseBody
    public ResponseResult<UserColumnDefined> findByUserIdModelCode(@ApiParam(value="\u6a21\u5757\u7f16\u7801") @RequestParam(required=true) String modelCode) {
        String userId = SpringSecurityUtils.getLoginUserId();
        if (StringUtils.isBlank((String)modelCode)) {
            throw new CommonException("\u6a21\u5757\u4e3a\u7a7a", "isNull", new Object[]{"\u7528\u6237\u4e0b\u6a21\u5757"});
        }
        UserColumnDefined userColumnDefined = this.userColumnDefinedService.queryObjByUserModelCode(userId, modelCode);
        return ResponseResult.success((Object)userColumnDefined);
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u81ea\u5b9a\u4e49")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody UserColumnDefined userColumnDefined) {
        if (StringUtils.isBlank((String)userColumnDefined.getId())) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25", "id_is_blank");
        }
        String userId = SpringSecurityUtils.getLoginUserId();
        userColumnDefined.setUserId(userId);
        this.userColumnDefinedService.modifyObj(userColumnDefined);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="GET", value="\u5220\u9664\u81ea\u5b9a\u4e49")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new CommonException("\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a", "id_is_blank");
        }
        this.userColumnDefinedService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u81ea\u5b9a\u4e49\u5217\u8868")
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<UserColumnDefined>> findByPage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 UserColumnDefined") @RequestBody(required=false) QueryParamWapper wapper) {
        UserColumnDefinedExample example = new UserColumnDefinedExample();
        example.setPageView((PageView<UserColumnDefined>)new PageView(pageNo, pageSize));
        if (wapper != null) {
            UserColumnDefinedExample.Criteria criteria = example.createCriteria();
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        PageView pageData = this.userColumnDefinedService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }
}

