/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.userprofile.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.core.entity.ResponseResult;
import com.els.base.userprofile.service.UserProfileService;
import com.els.base.userprofile.web.controller.vo.ProfileVO;
import com.els.base.userprofile.web.controller.vo.UserProfileVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u7528\u6237\u4e2a\u6027\u5316\u8bbe\u7f6e")
@Controller
@RequestMapping(value={"userProfile"})
public class UserProfileController {
    @Resource
    protected UserProfileService userProfileService;

    @ApiOperation(httpMethod="POST", value="\u7528\u6237\u8bbe\u7f6e\u4e2a\u6027\u5316\u9879\u76ee")
    @RequestMapping(value={"service/add/{platform}"})
    @ResponseBody
    public ResponseResult<String> add(@PathVariable String platform, @RequestBody List<UserProfileVO> userProfiles) {
        String currentUserId = SpringSecurityUtils.getLoginUserId();
        this.userProfileService.add(currentUserId, platform, userProfiles);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u6240\u6709\u7528\u6237\u81ea\u5b9a\u4e49\u8bbe\u7f6e\u9879")
    @RequestMapping(value={"service/display"})
    @ResponseBody
    public ResponseResult<List<ProfileVO>> display(String profileCode) {
        String currentUserId = SpringSecurityUtils.getLoginUserId();
        List<ProfileVO> list = this.userProfileService.display(currentUserId, profileCode);
        return ResponseResult.success(list);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u6240\u6709\u7528\u6237\u81ea\u5b9a\u4e49\u8bbe\u7f6e\u9879")
    @RequestMapping(value={"service/queryProfile/{platform}"})
    @ResponseBody
    public ResponseResult<Map<String, Set<String>>> listAll(@PathVariable String platform, String profileCode) {
        String currentUserId = SpringSecurityUtils.getLoginUserId();
        Map<String, Set<String>> list = this.userProfileService.queryProfile(currentUserId, platform, profileCode);
        return ResponseResult.success(list);
    }
}

