/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.userprofile.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.userprofile.dao.ProfileOptionMapper;
import com.els.base.userprofile.entity.ProfileOption;
import com.els.base.userprofile.entity.ProfileOptionExample;
import com.els.base.userprofile.service.ProfileOptionService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultProfileOptionService")
public class ProfileOptionServiceImpl
implements ProfileOptionService {
    @Resource
    protected ProfileOptionMapper profileOptionMapper;

    @CacheEvict(value={"profileOption"}, allEntries=true)
    public void addObj(ProfileOption t) {
        this.profileOptionMapper.insertSelective(t);
    }

    @CacheEvict(value={"profileOption"}, allEntries=true)
    public void deleteObjById(String id) {
        this.profileOptionMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"profileOption"}, allEntries=true)
    public void modifyObj(ProfileOption t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.profileOptionMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"profileOption"}, keyGenerator="redisKeyGenerator")
    public ProfileOption queryObjById(String id) {
        return this.profileOptionMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"profileOption"}, key="'ProfileOptionService_' + #root.methodName + '_'+ T(com.els.base.utils.encryption.Md5Utils).md5Object(#example)")
    public List<ProfileOption> queryAllObjByExample(ProfileOptionExample example) {
        return this.profileOptionMapper.selectByExample(example);
    }

    @Cacheable(value={"profileOption"}, key="'ProfileOptionService_' + #root.methodName + '_'+ T(com.els.base.utils.encryption.Md5Utils).md5Object(#example)")
    public PageView<ProfileOption> queryObjByPage(ProfileOptionExample example) {
        PageView<ProfileOption> pageView = example.getPageView();
        pageView.setQueryResult(this.profileOptionMapper.selectByExampleByPage(example));
        return pageView;
    }

    @CacheEvict(value={"profileOption"}, allEntries=true)
    public void deleteByExample(ProfileOptionExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.profileOptionMapper.deleteByExample(example);
    }

    @CacheEvict(value={"profileOption"}, allEntries=true)
    @Transactional
    public void addAll(List<ProfileOption> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> this.profileOptionMapper.insertSelective((ProfileOption)record));
    }
}

