package com.els.base.userprofile.web.controller;

import java.util.List;

import javax.annotation.Resource;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.core.entity.ResponseResult;
import com.els.base.userprofile.service.DefaultProfileService;
import com.els.base.userprofile.web.controller.vo.ProfileVO;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

@Api(value = "用户个性化默认设置")
@Controller
@RequestMapping("defaultProfile")
public class DefaultProfileController {
	@Resource
	protected DefaultProfileService defaultProfileService;

//	@ApiOperation(httpMethod = "POST", value = "创建T_BASE_DEFAULT_PROFILE")
//	@RequestMapping("service/create")
//	@ResponseBody
//	public ResponseResult<String> create(@RequestBody DefaultProfile defaultProfile) {
//		this.defaultProfileService.addObj(defaultProfile);
//		return ResponseResult.success();
//	}
//
//	@ApiOperation(httpMethod = "POST", value = "编辑T_BASE_DEFAULT_PROFILE")
//	@RequestMapping("service/edit")
//	@ResponseBody
//	public ResponseResult<String> edit(@RequestBody DefaultProfile defaultProfile) {
//		if (StringUtils.isBlank(defaultProfile.getId())) {
//			throw new CommonException("id 为空，保存失败");
//		}
//		this.defaultProfileService.modifyObj(defaultProfile);
//		return ResponseResult.success();
//	}
//
//	@ApiOperation(httpMethod = "POST", value = "删除T_BASE_DEFAULT_PROFILE")
//	@RequestMapping("service/deleteById")
//	@ResponseBody
//	public ResponseResult<String> deleteById(@RequestParam(required = true) String id) {
//		if (StringUtils.isBlank(id)) {
//			throw new CommonException("删除失败,id不能为空");
//		}
//		this.defaultProfileService.deleteObjById(id);
//		return ResponseResult.success();
//	}
//
//	@ApiOperation(httpMethod = "POST", value = "查询T_BASE_DEFAULT_PROFILE")
//	@ApiImplicitParams({
//			@ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
//			@ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
//			@ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 DefaultProfile", paramType = "body", dataType = "QueryParamWapper") })
//	@RequestMapping("service/findByPage")
//	@ResponseBody
//	public ResponseResult<PageView<DefaultProfile>> findByPage(@RequestParam(defaultValue = "0") int pageNo,
//			@RequestParam(defaultValue = "10") int pageSize, @RequestBody(required = false) QueryParamWapper wapper) {
//		DefaultProfileExample example = new DefaultProfileExample();
//		example.setPageView(new PageView<DefaultProfile>(pageNo, pageSize));
//
//		if (wapper != null) {
//			DefaultProfileExample.Criteria criteria = example.createCriteria();
//			CriteriaUtils.addCriterion(criteria, wapper);
//		}
//
//		PageView<DefaultProfile> pageData = this.defaultProfileService.queryObjByPage(example);
//		return ResponseResult.success(pageData);
//	}
	
	/**
	 * 新增用户自定义设置项
	 * @author zhoulongpeng
	 * @param  profileVO
	 * @return
	 */
	@ApiOperation(httpMethod = "POST", value = "新增用户自定义设置项")
	@RequestMapping("service/add")
	@ResponseBody
	public ResponseResult<String> add(@RequestBody ProfileVO profileVO) {
		this.defaultProfileService.insertObj(profileVO);
		return ResponseResult.success();
	}
	
	/**
	 * 修改用户自定义设置项
	 * @author zhoulongpeng
	 * @param  profileVO
	 * @return
	 */
	@ApiOperation(httpMethod = "POST", value = "新增用户自定义设置项")
	@RequestMapping("service/update")
	@ResponseBody
	public ResponseResult<String> update(@RequestBody ProfileVO profileVO) {
		this.defaultProfileService.updateObj(profileVO);
		return ResponseResult.success();
	}
	
	/**
	 * 查询用户自定义设置项列表
	 * @author zhoulongpeng
	 * @param  profileVO
	 * @return
	 */
	@ApiOperation(httpMethod = "POST", value = "查询所有用户自定义设置项")
	@RequestMapping("service/list")
	@ResponseBody
	public ResponseResult<List<ProfileVO>> listAll() {
		List<ProfileVO> list = defaultProfileService.listAll(null);
		return ResponseResult.success(list);
	}
	
}