package com.els.base.userprofile.web.controller;

import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.Resource;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.core.entity.ResponseResult;
import com.els.base.userprofile.service.UserProfileService;
import com.els.base.userprofile.web.controller.vo.ProfileVO;
import com.els.base.userprofile.web.controller.vo.UserProfileVO;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

@Api(value = "用户个性化设置")
@Controller
@RequestMapping("userProfile")
public class UserProfileController {
	@Resource
	protected UserProfileService userProfileService;

//	@ApiOperation(httpMethod = "POST", value = "创建T_BASE_USER_PROFILE")
//	@RequestMapping("service/create")
//	@ResponseBody
//	public ResponseResult<String> create(@RequestBody UserProfile userProfile) {
//		
//		this.userProfileService.addObj(userProfile);
//		
//		return ResponseResult.success();
//	}
//
//	@ApiOperation(httpMethod = "POST", value = "编辑T_BASE_USER_PROFILE")
//	@RequestMapping("service/edit")
//	@ResponseBody
//	public ResponseResult<String> edit(@RequestBody UserProfile userProfile) {
//		if (StringUtils.isBlank(userProfile.getId())) {
//			throw new CommonException("id 为空，保存失败");
//		}
//		this.userProfileService.modifyObj(userProfile);
//		return ResponseResult.success();
//	}
//
//	@ApiOperation(httpMethod = "POST", value = "删除T_BASE_USER_PROFILE")
//	@RequestMapping("service/deleteById")
//	@ResponseBody
//	public ResponseResult<String> deleteById(@RequestParam(required = true) String id) {
//		if (StringUtils.isBlank(id)) {
//			throw new CommonException("删除失败,id不能为空");
//		}
//		this.userProfileService.deleteObjById(id);
//		return ResponseResult.success();
//	}
//
//	@ApiOperation(httpMethod = "POST", value = "查询T_BASE_USER_PROFILE")
//	@ApiImplicitParams({
//			@ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
//			@ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
//			@ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 UserProfile", paramType = "body", dataType = "QueryParamWapper") })
//	@RequestMapping("service/findByPage")
//	@ResponseBody
//	public ResponseResult<PageView<UserProfile>> findByPage(@RequestParam(defaultValue = "0") int pageNo,
//			@RequestParam(defaultValue = "10") int pageSize, @RequestBody(required = false) QueryParamWapper wapper) {
//		UserProfileExample example = new UserProfileExample();
//		example.setPageView(new PageView<UserProfile>(pageNo, pageSize));
//
//		if (wapper != null) {
//			UserProfileExample.Criteria criteria = example.createCriteria();
//			CriteriaUtils.addCriterion(criteria, wapper);
//		}
//
//		PageView<UserProfile> pageData = this.userProfileService.queryObjByPage(example);
//		return ResponseResult.success(pageData);
//	}
	
	@ApiOperation(httpMethod = "POST", value = "用户设置个性化项目")
	@RequestMapping("service/add/{platform}")
	@ResponseBody
	public ResponseResult<String> add(@PathVariable String platform, 
									  @RequestBody List<UserProfileVO> userProfiles) {
		
		String currentUserId = SpringSecurityUtils.getLoginUserId();
		userProfileService.add(currentUserId, platform, userProfiles);
		
		return ResponseResult.success();
	}
	
	/**
	 * 展示用户自定义设置项列表
	 * @author zhoulongpeng
	 * @param  profileVO
	 * @return
	 */
	@ApiOperation(httpMethod = "POST", value = "查询所有用户自定义设置项")
	@RequestMapping("service/display")
	@ResponseBody
	public ResponseResult<List<ProfileVO>> display(String profileCode) {
		String currentUserId = SpringSecurityUtils.getLoginUserId();
		List<ProfileVO> list = userProfileService.display(currentUserId, profileCode);
		return ResponseResult.success(list);
	}
	
	/**
	 * 查询用户自定义设置项列表
	 * @author zhoulongpeng
	 * @param  profileVO
	 * @return
	 */
	@ApiOperation(httpMethod = "POST", value = "查询所有用户自定义设置项")
	@RequestMapping("service/queryProfile/{platform}")
	@ResponseBody
	public ResponseResult<Map<String, Set<String>>> listAll(@PathVariable String platform, String profileCode) {
		String currentUserId = SpringSecurityUtils.getLoginUserId();
		Map<String, Set<String>> list = userProfileService.queryProfile(currentUserId, platform, profileCode);
		return ResponseResult.success(list);
	}
	
}