package com.els.base.userprofile.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;

@ApiModel(value="T_BASE_DEFAULT_PROFILE")
public class DefaultProfile implements Serializable {
    @ApiModelProperty("表的主键")
    private String id;

    @ApiModelProperty("配置的类型：1单选，2多选")
    private Integer profileType;

    @ApiModelProperty("配置项的名称")
    private String name;

    @ApiModelProperty("配置项的默认设置,值的格式：{PC: [1], IOS: [A, B], ANDROID: [0]}")
    private String defaultValue;

    @ApiModelProperty("设置项的CODE值")
    private String code;

    @ApiModelProperty("设置项的顺序")
    private Integer sort;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public Integer getProfileType() {
        return profileType;
    }

    public void setProfileType(Integer profileType) {
        this.profileType = profileType;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name == null ? null : name.trim();
    }

    public String getDefaultValue() {
        return defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue == null ? null : defaultValue.trim();
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code == null ? null : code.trim();
    }

    public Integer getSort() {
        return sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }
}