package com.els.base.userprofile.service;

import java.util.List;

import com.els.base.core.service.BaseService;
import com.els.base.userprofile.entity.DefaultProfile;
import com.els.base.userprofile.entity.DefaultProfileExample;
import com.els.base.userprofile.web.controller.vo.ProfileVO;

public interface DefaultProfileService extends BaseService<DefaultProfile, DefaultProfileExample, String> {

	/**
	 * 新增一个用户自定义设置项
	 * @author  zhoulongpeng
	 * @param   profileVO
	 */
	public void insertObj(ProfileVO profileVO);
	
	/**
	 * 更新一个用户自定义设置项
	 * @author  zhoulongpeng
	 * @param   profileVO
	 */
	public void updateObj(ProfileVO profileVO);
	
	/**
	 * 查询用户自定义设置项列表
	 * @author  zhoulongpeng
	 * @param   code
	 * @return  List<ProfileVO>
	 */
	public List<ProfileVO> listAll(String code);
	
}