package com.els.base.userprofile.service;

import java.util.List;
import java.util.Map;
import java.util.Set;

import com.els.base.core.service.BaseService;
import com.els.base.userprofile.entity.UserProfile;
import com.els.base.userprofile.entity.UserProfileExample;
import com.els.base.userprofile.web.controller.vo.ProfileVO;
import com.els.base.userprofile.web.controller.vo.UserProfileVO;

public interface UserProfileService extends BaseService<UserProfile, UserProfileExample, String> {

	/**
	 * 用户设置个性化
	 * @author  zhoulongpeng
	 * @param userId
	 * @param platform
	 * @param userProfiles
	 */
	public void add(String userId, String platform, List<UserProfileVO> userProfiles);
	
	/**
	 * 展示用户自定义设置项列表
	 * @author  zhoulongpeng
	 * @param   userId
	 * @param   code
	 * @return  List<ProfileVO>
	 */
	public List<ProfileVO> display(String userId, String code);
	
	/**
	 * 查询用户自定义设置项列
	 * @param userId
	 * @param platform
	 * @param code
	 * @return {code : values}
	 */
	public Map<String, Set<String>> queryProfile(String userId, String platform, String code);
	
	

}