/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.utils.txtImport;

import com.els.base.utils.txtImport.BigDecimalConverter;
import com.els.base.utils.txtImport.DateConverter;
import com.els.base.utils.txtImport.DoubleConverter;
import com.els.base.utils.txtImport.IntegerConverter;
import com.els.base.utils.txtImport.LongConverter;
import com.els.base.utils.txtImport.StringToObjectConverter;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;

public class ConverterFactory {
    private final Map<String, StringToObjectConverter> toObjMap = new Hashtable<String, StringToObjectConverter>();
    private static ConverterFactory factory = new ConverterFactory();

    private void register() {
        this.toObjMap.put(Integer.class.toString(), new IntegerConverter());
        this.toObjMap.put(BigDecimal.class.toString(), new BigDecimalConverter());
        this.toObjMap.put(Date.class.toString(), new DateConverter());
        this.toObjMap.put(Long.class.toString(), new LongConverter());
        this.toObjMap.put(Double.class.toString(), new DoubleConverter());
    }

    public static StringToObjectConverter getDefaultToObjConverter(Class clazz) {
        return factory.getToObjMap().get(clazz.toString());
    }

    private ConverterFactory() {
        this.register();
    }

    public Map<String, StringToObjectConverter> getToObjMap() {
        return this.toObjMap;
    }
}

