/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.utils;

import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringContextHolder
implements ApplicationContextAware {
    private static ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext arg0) throws BeansException {
        applicationContext = arg0;
    }

    public static ApplicationContext getApplicationContext() {
        SpringContextHolder.checkApplicationContext();
        return applicationContext;
    }

    public static <T> T getBean(String name) {
        return (T)SpringContextHolder.getApplicationContext().getBean(name);
    }

    public static <T> T getOneBean(Class<T> clazz) {
        Map beanMaps = SpringContextHolder.getApplicationContext().getBeansOfType(clazz);
        if (beanMaps != null && !beanMaps.isEmpty()) {
            return (T)beanMaps.values().iterator().next();
        }
        return null;
    }

    public static <T> Map<String, T> getBeans(Class<T> clazz) {
        Map beanMaps = SpringContextHolder.getApplicationContext().getBeansOfType(clazz);
        return beanMaps;
    }

    private static void checkApplicationContext() {
        if (applicationContext == null) {
            throw new IllegalStateException("spring \u7684\u914d\u7f6e\u6587\u4ef6\u4e2d\uff0c\u672a\u914d\u7f6eSpringContextHolder");
        }
    }

    public static String getProperty(String key) {
        return SpringContextHolder.getApplicationContext().getEnvironment().getProperty(key);
    }

    public static String getProperty(String key, String defaultValue) {
        return SpringContextHolder.getApplicationContext().getEnvironment().getProperty(key, defaultValue);
    }
}

