/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.utils.txtImport;

import com.els.base.utils.reflect.ReflectUtils;
import com.els.base.utils.txtImport.ConverterFactory;
import com.els.base.utils.txtImport.CreateResponse;
import com.els.base.utils.txtImport.StringToObjectConverter;
import com.els.base.utils.txtImport.TxtImportResponse;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class TxtImportUtils {
    private static Logger logger = LoggerFactory.getLogger(TxtImportUtils.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> TxtImportResponse<T> importTxt(MultipartFile file, String strTokenizer, Class<T> clazz, String[] keys) {
        logger.info("\u5b57\u7b26\u5206\u9694\u7b26\uff1a{}", (Object)strTokenizer);
        if (TxtImportUtils.checkFile(file)) {
            TxtImportResponse response = CreateResponse.createResponse("501");
            response.setMessage("\u6587\u4ef6\u683c\u5f0f\u4e0d\u662fTXT\uff0c\u5bfc\u5165\u5931\u8d25\uff01");
            logger.error("TXT\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff1a{}", (Object)response.getMessage());
            return response;
        }
        try (InputStream inputStream = file.getInputStream();
             BufferedReader bf = new BufferedReader(new InputStreamReader(inputStream, "gbk"));){
            ArrayList<T> list = new ArrayList<T>(0);
            boolean flag = true;
            block26: while (true) {
                Object[] data;
                String line;
                if ((line = bf.readLine()) != null) {
                    logger.info("\u6bcf\u884c\u7684\u6570\u636e\uff1a{}", (Object)line);
                    if ("".equals(line)) continue;
                    if (flag) {
                        flag = false;
                        logger.info("\u53bb\u6389\u7b2c\u4e00\u884c\u6570\u636e");
                        continue;
                    }
                    data = TxtImportUtils.dealString(line, strTokenizer).split(strTokenizer);
                    TxtImportUtils.stringReplace((String[])data);
                    logger.info("\u5904\u7406\u540e\u7684\u6570\u636e\uff1a{}", (Object)Arrays.toString(data));
                    if (data.length != keys.length) {
                        TxtImportResponse response = CreateResponse.createResponse("500");
                        response.setMessage("\u5bfc\u5165\u5931\u8d25,\u5b57\u6bb5\u6570\u91cf\u5fc5\u987b\u4e0e\u6587\u4ef6\u6bcf\u884c\u7684\u503c\u6570\u91cf\u76f8\u540c\uff01");
                        logger.error("TXT\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff1a{}", (Object)response.getMessage());
                        TxtImportResponse txtImportResponse = response;
                        return txtImportResponse;
                    }
                } else {
                    TxtImportResponse response = CreateResponse.createResponse("200");
                    response.setList(list);
                    return response;
                }
                Field[] fields = clazz.getDeclaredFields();
                T object = clazz.newInstance();
                int i = 0;
                while (true) {
                    if (i < keys.length) {
                    } else {
                        list.add(object);
                        continue block26;
                    }
                    for (int j = 0; j < fields.length; ++j) {
                        Field f = fields[j];
                        f.setAccessible(true);
                        if (!keys[i].equals(f.getName())) continue;
                        Class<?> type = FieldUtils.getField(object.getClass(), (String)f.getName(), (boolean)true).getType();
                        if (type.equals(String.class)) {
                            ReflectUtils.setValue(object, f.getName(), data[i]);
                            break;
                        }
                        StringToObjectConverter converter = ConverterFactory.getDefaultToObjConverter(type);
                        if (converter == null) {
                            throw new RuntimeException("\u627e\u4e0d\u5230\u5408\u9002\u8f6c\u6362\u5668 class[" + type + "]");
                        }
                        ReflectUtils.setValue(object, f.getName(), converter.convert((String)data[i]));
                        break;
                    }
                    ++i;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            TxtImportResponse response = CreateResponse.createResponse("500");
            response.setMessage("TXT\u5bfc\u5165\u51fa\u9519\uff01");
            logger.error("TXT\u6587\u4ef6\u5bfc\u5165\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            return response;
        }
    }

    private static void stringReplace(String[] data) {
        for (int i = 0; i < data.length; ++i) {
            if (!"".equals(data[i])) continue;
            data[i] = null;
        }
    }

    private static String dealString(String data, String strTokenizer) {
        char lastChar = data.charAt(data.length() - 1);
        return strTokenizer.charAt(strTokenizer.length() - 1) == lastChar ? data + null : data;
    }

    private static boolean checkFile(MultipartFile file) {
        if (file == null) {
            throw new RuntimeException("\u6587\u4ef6\u4e3a\u7a7a");
        }
        String type = file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf("."));
        logger.info("\u6587\u4ef6\u540d\uff1a{}", (Object)file.getOriginalFilename());
        logger.info("\u6587\u4ef6\u540e\u7f00\uff1a{}", (Object)type);
        return !".txt".equalsIgnoreCase(type);
    }
}

