/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.utils.json;

import com.els.base.utils.SpringContextHolder;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;

public class JsonUtils {
    private static final String LOCK = "lock";
    private static ObjectMapper objectMapper = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjectMapper getObjectMapper() {
        if (objectMapper != null) {
            return objectMapper;
        }
        String string = LOCK;
        synchronized (LOCK) {
            if (objectMapper != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return objectMapper;
            }
            objectMapper = SpringContextHolder.getOneBean(ObjectMapper.class) == null ? new ObjectMapper() : SpringContextHolder.getOneBean(ObjectMapper.class);
            // ** MonitorExit[var0] (shouldn't be in output)
            return objectMapper;
        }
    }

    public static String writeValueAsString(Object object) throws JsonProcessingException {
        return JsonUtils.getObjectMapper().writeValueAsString(object);
    }

    public static <T> T convertValue(String fromValue, Class<T> toValueType) throws JsonParseException, JsonMappingException, IOException {
        JsonUtils.getObjectMapper().configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        return (T)JsonUtils.getObjectMapper().readValue(fromValue, toValueType);
    }

    public static <T> T convertCollection(String fromValue, Class<T> collectionClass, Class<?> subCollectionClass, Class<?> ... elementClasses) throws JsonParseException, JsonMappingException, IOException {
        JavaType javaType = JsonUtils.getObjectMapper().getTypeFactory().constructParametricType(collectionClass, (Class[])elementClasses);
        return (T)JsonUtils.getObjectMapper().readValue(fromValue, javaType);
    }

    public static JavaType getCollectionType(Class<?> collectionClass, Class<?> subCollectionClass, Class<?> ... elementClasses) {
        return JsonUtils.getObjectMapper().getTypeFactory().constructParametricType(collectionClass, (Class[])elementClasses);
    }
}

