/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.utils.math;

public final class RMBUtil {
    private static String[] HanDigiStr = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
    private static String[] HanDiviStr = new String[]{"", "\u62fe", "\u4f70", "\u4edf", "\u4e07", "\u62fe", "\u4f70", "\u4edf", "\u4ebf", "\u62fe", "\u4f70", "\u4edf", "\u4e07", "\u62fe", "\u4f70", "\u4edf", "\u4ebf", "\u62fe", "\u4f70", "\u4edf", "\u4e07", "\u62fe", "\u4f70", "\u4edf"};

    private RMBUtil() {
    }

    public static final String convert(double val) {
        String signStr = "";
        String tailStr = "";
        if (val < 0.0) {
            val = -val;
            signStr = "\u8d1f";
        }
        if (val > 1.0E14 || val < -1.0E14) {
            return "\u6570\u503c\u4f4d\u6570\u8fc7\u5927!";
        }
        long temp = Math.round(val * 100.0);
        long integer = temp / 100L;
        long fraction = temp % 100L;
        int jiao = (int)fraction / 10;
        int fen = (int)fraction % 10;
        if (jiao == 0 && fen == 0) {
            tailStr = "\u6574";
        } else {
            tailStr = HanDigiStr[jiao];
            if (jiao != 0) {
                tailStr = tailStr + "\u89d2";
            }
            if (integer == 0L && jiao == 0) {
                tailStr = "";
            }
            if (fen != 0) {
                tailStr = tailStr + HanDigiStr[fen] + "\u5206";
            }
        }
        return signStr + RMBUtil.positiveIntegerToHanStr(String.valueOf(integer)) + "\u5143" + tailStr;
    }

    private static String positiveIntegerToHanStr(String numStr) {
        String rmbStr = "";
        boolean lastzero = false;
        boolean hasvalue = false;
        int len = numStr.length();
        if (len > 15) {
            return "\u6570\u503c\u8fc7\u5927!";
        }
        for (int i = len - 1; i >= 0; --i) {
            if (numStr.charAt(len - i - 1) == ' ') continue;
            int n = numStr.charAt(len - i - 1) - 48;
            if (n < 0 || n > 9) {
                return "\u8f93\u5165\u542b\u975e\u6570\u5b57\u5b57\u7b26!";
            }
            if (n != 0) {
                if (lastzero) {
                    rmbStr = rmbStr + HanDigiStr[0];
                }
                if (n != 1 || i % 4 != 1 || i != len - 1) {
                    rmbStr = rmbStr + HanDigiStr[n];
                }
                rmbStr = rmbStr + HanDiviStr[i];
                hasvalue = true;
            } else if (i % 8 == 0 || i % 8 == 4 && hasvalue) {
                rmbStr = rmbStr + HanDiviStr[i];
            }
            if (i % 8 == 0) {
                hasvalue = false;
            }
            lastzero = n == 0 && i % 4 != 0;
        }
        if (rmbStr.length() == 0) {
            return HanDigiStr[0];
        }
        return rmbStr;
    }
}

