/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.utils.qrcode;

import com.swetake.util.Qrcode;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.imageio.ImageIO;

public class QrcodeUtils {
    public static final int MAX_SIZE = 2331;
    public static final int MIN_UNIT = 1;
    public static final int PIXOFF = 2;

    public static BufferedImage writeQrcode(String content, String charsetName, int width) throws UnsupportedEncodingException {
        byte[] contentBytes = content.getBytes(charsetName);
        int contentLength = contentBytes.length;
        if (contentLength > 2331) {
            throw new IllegalArgumentException("\u5185\u5bb9\u957f\u5ea6\u8d85\u8fc7\u4e8c\u7ef4\u7801\u5b58\u50a8\u4e0a\u9650 2331 byte\uff0c\u65e0\u6cd5\u751f\u6210\u4e8c\u7ef4\u7801\u3002");
        }
        int version = QrcodeUtils.getVersionFormLength(contentLength);
        Qrcode qrcodeHandler = new Qrcode();
        qrcodeHandler.setQrcodeErrorCorrect('M');
        qrcodeHandler.setQrcodeEncodeMode('B');
        qrcodeHandler.setQrcodeVersion(version);
        boolean[][] codeOut = qrcodeHandler.calQrcode(contentBytes);
        int codeLength = codeOut.length;
        int minWidth = 1 * codeLength + 2;
        if (width < minWidth) {
            throw new IllegalArgumentException("\u5bbd\u5ea6\u8fc7\u5c11\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002\u5f53\u524d\u5185\u5bb9\u4e0b\u6700\u5c0f\u5bbd\u5ea6\u662f" + minWidth + "\uff0c179\u7684\u5bbd\u5ea6\uff0c\u80fd\u6ee1\u8db3\u6240\u6709\u7684\u8bbe\u7f6e\u3002");
        }
        double unitSizeDouble = (double)(width - 2) / (double)codeLength;
        int unitSize = (int)Math.floor(unitSizeDouble);
        int height = width;
        BufferedImage bufImg = new BufferedImage(width, height, 1);
        Graphics2D gs = bufImg.createGraphics();
        gs.setBackground(Color.WHITE);
        gs.clearRect(0, 0, width, height);
        gs.setColor(Color.BLACK);
        for (int i = 0; i < codeOut.length; ++i) {
            for (int j = 0; j < codeOut.length; ++j) {
                if (!codeOut[j][i]) continue;
                gs.fillRect(j * unitSize + 2, i * unitSize + 2, unitSize, unitSize);
            }
        }
        gs.dispose();
        bufImg.flush();
        return bufImg;
    }

    private static int getVersionFormLength(int length) {
        if (length > 0 && length <= 14) {
            return 1;
        }
        if (length > 14 && length <= 26) {
            return 2;
        }
        if (length > 26 && length <= 42) {
            return 3;
        }
        if (length > 42 && length <= 62) {
            return 4;
        }
        if (length > 62 && length <= 84) {
            return 5;
        }
        if (length > 84 && length <= 106) {
            return 6;
        }
        if (length > 106 && length <= 122) {
            return 7;
        }
        if (length > 122 && length <= 152) {
            return 8;
        }
        if (length > 152 && length <= 180) {
            return 9;
        }
        if (length > 180 && length <= 213) {
            return 10;
        }
        if (length > 213 && length <= 251) {
            return 11;
        }
        if (length > 251 && length <= 287) {
            return 12;
        }
        if (length > 287 && length <= 331) {
            return 13;
        }
        if (length > 331 && length <= 362) {
            return 14;
        }
        if (length > 362 && length <= 412) {
            return 15;
        }
        if (length > 412 && length <= 450) {
            return 16;
        }
        if (length > 450 && length <= 504) {
            return 17;
        }
        if (length > 504 && length <= 560) {
            return 18;
        }
        if (length > 560 && length <= 624) {
            return 19;
        }
        if (length > 624 && length <= 666) {
            return 20;
        }
        if (length > 666 && length <= 711) {
            return 21;
        }
        if (length > 711 && length <= 779) {
            return 22;
        }
        if (length > 779 && length <= 857) {
            return 23;
        }
        if (length > 857 && length <= 911) {
            return 24;
        }
        if (length > 911 && length <= 997) {
            return 25;
        }
        if (length > 997 && length <= 1059) {
            return 26;
        }
        if (length > 1059 && length <= 1125) {
            return 27;
        }
        if (length > 1125 && length <= 1190) {
            return 28;
        }
        if (length > 1190 && length <= 1264) {
            return 29;
        }
        if (length > 1264 && length <= 1370) {
            return 30;
        }
        if (length > 1370 && length <= 1452) {
            return 31;
        }
        if (length > 1452 && length <= 1538) {
            return 32;
        }
        if (length > 1538 && length <= 1628) {
            return 33;
        }
        if (length > 1628 && length <= 1722) {
            return 34;
        }
        if (length > 1722 && length <= 1809) {
            return 35;
        }
        if (length > 1809 && length <= 1911) {
            return 36;
        }
        if (length > 1911 && length <= 1989) {
            return 37;
        }
        if (length > 1989 && length <= 2099) {
            return 38;
        }
        if (length > 2099 && length <= 2213) {
            return 39;
        }
        if (length > 2213 && length <= 2331) {
            return 40;
        }
        throw new IllegalArgumentException("\u4fe1\u606f\u957f\u5ea6\u8d85\u957f\uff0c\u65e0\u6cd5\u8f6c\u6210\u4e8c\u7ef4\u7801");
    }

    public static boolean writeQrcode(String content, String charsetName, int width, OutputStream out) throws IOException {
        BufferedImage bufImg = QrcodeUtils.writeQrcode(content, charsetName, width);
        return ImageIO.write((RenderedImage)bufImg, "png", out);
    }

    public static boolean writeQrcode(String content, String charsetName, int width, File out) throws IOException {
        BufferedImage bufImg = QrcodeUtils.writeQrcode(content, charsetName, width);
        return ImageIO.write((RenderedImage)bufImg, "png", out);
    }

    public static void main(String[] args) throws IOException {
        File file = new File("C:\\Users\\hzy\\Desktop\\abc.jpg");
        String content = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=wx4cd8d60cd66ac9e3&redirect_uri=http%3A%2F%2Fhzywx.wicp.net%2FEMIS%2FWechatAPI%2Foauth2Openid%2FITBwITHtTX-z7nHz7W6z7nIqUuiW2d7sC38QAYyOAY21iYOaiYXpB3XrK6y5ITHtITIRITHt2O1z7nHz7W6z7nIDBdyrITi_ITIcITIcB9NeC3XGvU8zA9NnPYWz7oKeT3OFPw1tye_tPYyXvZylvYbVBc2VBwNDBcXFITicAdIqKd2nB6zoITi67uoz7nHz7o7z7nIwft1t791ufk1t7oXkT1Dz7nHziWf&response_type=code&scope=snsapi_base#wechat_redirect";
        BufferedImage image = QrcodeUtils.writeQrcode(content, "UTF-8", 83);
        ImageIO.write((RenderedImage)image, "jpg", file);
    }
}

