/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.utils.template;

import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.beetl.core.Configuration;
import org.beetl.core.ErrorHandler;
import org.beetl.core.GroupTemplate;
import org.beetl.core.ReThrowConsoleErrorHandler;
import org.beetl.core.ResourceLoader;
import org.beetl.core.Template;
import org.beetl.core.resource.AllowAllMatcher;
import org.beetl.core.resource.ClasspathResourceLoader;
import org.beetl.core.resource.CompositeResourceLoader;
import org.beetl.core.resource.Matcher;
import org.beetl.core.resource.StartsWithMatcher;
import org.beetl.core.resource.StringTemplateResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class BeetlTemplateUtils {
    private static Logger logger;
    public static GroupTemplate gt;
    private static final String PREFIX_BEETLE = "str:";

    public static String renderFromFile(String fileName, Map<String, Object> params) {
        Template t = gt.getTemplate(fileName);
        t.binding(params);
        return t.render();
    }

    public static String renderFromFile(String fileName, String varName, Object data) {
        Template t = gt.getTemplate(fileName);
        t.binding(varName, data);
        return t.render();
    }

    public static void renderFromFile(String fileName, Writer writer, Map<String, Object> params) {
        Template t = gt.getTemplate(fileName);
        t.binding(params);
        t.renderTo(writer);
    }

    public static String renderFromString(String template, String varName, Object data) {
        template = PREFIX_BEETLE.concat(template);
        Template t = gt.getTemplate(template);
        t.binding(varName, data);
        return t.render();
    }

    public static void renderFromString(String template, Writer writer, Map<String, Object> params) {
        template = PREFIX_BEETLE.concat(template);
        Template t = gt.getTemplate(template);
        t.binding(params);
        t.renderTo(writer);
    }

    static {
        Configuration cfg;
        logger = LoggerFactory.getLogger(BeetlTemplateUtils.class);
        gt = null;
        StringTemplateResourceLoader stringResourceLoader = new StringTemplateResourceLoader();
        ClasspathResourceLoader classpathResourceLoader = new ClasspathResourceLoader("template/");
        CompositeResourceLoader loader = new CompositeResourceLoader();
        loader.addResourceLoader((Matcher)new StartsWithMatcher(PREFIX_BEETLE), (ResourceLoader)stringResourceLoader);
        loader.addResourceLoader((Matcher)new AllowAllMatcher(), (ResourceLoader)classpathResourceLoader);
        try {
            cfg = Configuration.defaultConfiguration();
            cfg.setHtmlTagFlag("cms-");
            cfg.setHtmlTagStart("<cms-");
            cfg.setHtmlTagEnd("</cms-");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        gt = new GroupTemplate((ResourceLoader)loader, cfg);
        gt.setErrorHandler((ErrorHandler)new ReThrowConsoleErrorHandler());
        try {
            PathMatchingResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver();
            Resource[] resources = resourceResolver.getResources("classpath*:/beetleTag/*.properties");
            HashMap tagName2Class = new HashMap();
            for (int i = 0; resources != null && i < resources.length; ++i) {
                Properties properties = new Properties();
                properties.load(resources[i].getInputStream());
                for (String string : properties.keySet()) {
                    Class<?> clazz = Class.forName(properties.getProperty(string));
                    if (tagName2Class.containsKey(string)) {
                        if (((Class)tagName2Class.get(string)).equals(clazz)) continue;
                        throw new IllegalArgumentException(MessageFormat.format("\u51fa\u73b0\u91cd\u590d\u7684tag\u6807\u7b7e,\u5df2\u6709\u4e00\u4e2a[{0}],\u73b0\u5728\u91cd\u590d\u4e00\u4e2a[{1}]", tagName2Class.get(string), clazz));
                    }
                    tagName2Class.put(string, clazz);
                }
            }
            for (Map.Entry tagNameAndClass : tagName2Class.entrySet()) {
                gt.registerTag((String)tagNameAndClass.getKey(), (Class)tagNameAndClass.getValue());
            }
        }
        catch (IOException | ClassNotFoundException e) {
            logger.error("\u6a21\u677ftag\u52a0\u8f7d\u5f02\u5e38", (Throwable)e);
        }
    }
}

