/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.utils.pdf;

import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.file.BaseFileUtils;
import com.els.base.utils.pdf.HtmlToPdfInterceptor;
import com.els.base.utils.pdf.HtmlToPdfParam;
import com.els.base.utils.uuid.UUIDGenerator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public abstract class HtmlToPdfUtils {
    private static Logger logger = LoggerFactory.getLogger(HtmlToPdfUtils.class);
    public static final String PAGE_SIZE_A4 = "A4";
    public static final String PAGE_SIZE_A5 = "A5";
    public static final String PAGE_SIZE_LETTER = "LETTER";
    public static final String PAGE_SIZE_LETTER_A5 = "LETTER_A5";
    public static String WXHTMLTOPDF_BIN_PATH = "/usr/local/bin/wkhtmltopdf";

    public static void generatePdf(String srcHtml, File destPdf) throws IOException, InterruptedException {
        HtmlToPdfUtils.generatePdf(srcHtml, destPdf, PAGE_SIZE_A4);
    }

    public static void generatePdf(String srcHtml, File destPdf, String pageSize) throws IOException, InterruptedException {
        HtmlToPdfUtils.generatePdf(srcHtml, destPdf, pageSize, true);
    }

    public static void generatePdf(String srcHtml, File destPdf, String pageSize, boolean isVertical) throws IOException, InterruptedException {
        HtmlToPdfUtils.generatePdf(srcHtml, destPdf, pageSize, isVertical, null);
    }

    public static void generatePdf(String srcHtml, File destPdf, String pageSize, boolean isVertical, String title) throws IOException, InterruptedException {
        HtmlToPdfParam params = new HtmlToPdfParam().setVertical(isVertical).setPageSize(pageSize).setTitle(title);
        HtmlToPdfUtils.generatePdf(srcHtml, destPdf, params);
    }

    public static void generatePdf(String srcHtml, File destPdf, float width, float height, String title) throws IOException, InterruptedException {
        HtmlToPdfParam params = new HtmlToPdfParam().setPageHeight(String.valueOf(height)).setPageWidth(String.valueOf(width)).setTitle(title);
        HtmlToPdfUtils.generatePdf(srcHtml, destPdf, params);
    }

    public static void generatePdf(String html, File file, HtmlToPdfParam params) throws IOException, InterruptedException {
        String fileName = UUIDGenerator.generateUUID() + ".content.html";
        File htmlFile = BaseFileUtils.createEmptyTmpFile(fileName, html);
        HtmlToPdfUtils.generatePdf(htmlFile, file, params);
        try {
            FileUtils.forceDelete((File)htmlFile);
            if (params.getHeaderFile() != null) {
                FileUtils.forceDelete((File)params.getHeaderFile());
            }
            if (params.getFooterFile() != null) {
                FileUtils.forceDelete((File)params.getFooterFile());
            }
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u4e34\u65f6\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
    }

    public static void generatePdf(File htmlFile, File file, HtmlToPdfParam params) throws IOException, InterruptedException {
        if (file == null) {
            throw new NullPointerException("pdf file cannot be null");
        }
        if (!file.exists()) {
            FileUtils.touch((File)file);
        }
        StringBuffer cmd = new StringBuffer();
        cmd.append(WXHTMLTOPDF_BIN_PATH).append(" ");
        cmd.append(params.generateCmdParams());
        cmd.append(htmlFile.getAbsolutePath()).append(" ").append(file.getAbsolutePath());
        logger.info("run cmd:" + cmd);
        Process proc = Runtime.getRuntime().exec(cmd.toString());
        HtmlToPdfUtils.runCmdLog(proc.getInputStream(), proc.getErrorStream());
        proc.waitFor();
    }

    private static void runCmdLog(InputStream outputStream, InputStream errorStream) {
        HtmlToPdfInterceptor output = new HtmlToPdfInterceptor(outputStream);
        HtmlToPdfInterceptor error = new HtmlToPdfInterceptor(errorStream);
        ThreadPoolTaskExecutor executor = SpringContextHolder.getOneBean(ThreadPoolTaskExecutor.class);
        executor.execute((Runnable)output);
        executor.execute((Runnable)error);
    }

    public static void main(String[] args) {
        String tempDir = HtmlToPdfUtils.class.getClassLoader().getResource("") + "tempDir";
        String htmlFilePath = tempDir + "/" + System.currentTimeMillis() + ".html";
        File htmlFile = new File(htmlFilePath);
        System.out.println(htmlFile.getAbsolutePath());
    }

    static {
        try {
            String binPath = SpringContextHolder.getProperty("wkhtmltopdf.bin.path");
            if (StringUtils.isNotBlank((String)binPath)) {
                File binFile = new File(binPath);
                if (binFile.exists()) {
                    WXHTMLTOPDF_BIN_PATH = binPath;
                } else {
                    logger.warn("\u627e\u4e0d\u5230\u914d\u7f6e\u6587\u4ef6\u4e2dwkhtml\u7684\u53ef\u6267\u884c\u6587\u4ef6\uff0c\u914d\u7f6e\u7684\u8def\u5f84\uff1a" + binPath);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u8bbe\u7f6ewkhtml\u7684\u53ef\u6267\u884c\u6587\u4ef6\u8def\u5f84\u5931\u8d25", (Throwable)e);
        }
    }
}

