/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.utils.pdf;

import com.els.base.utils.file.BaseFileUtils;
import com.els.base.utils.uuid.UUIDGenerator;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;

public class HtmlToPdfParam {
    public static final String A4 = "A4";
    public static final String A5 = "A5";
    public static final String LETTER = "Letter";
    public static final String LETTER_A5 = "LetterA5";
    private String marginBottom = "0mm";
    private String marginLeft = "0mm";
    private String marginRight = "0mm";
    private String marginTop = "0mm";
    private boolean disableSmartShrinking = true;
    private boolean printMediaType = true;
    private String pageHeight;
    private String pageWidth;
    private Integer dpi = 250;
    private String pageSize;
    private String title;
    private String headerSpacing;
    private String footerSpacing;
    private boolean isVertical = true;
    private String headerHtml;
    private String footerHtml;
    private File headerFile;
    private File footerFile;

    public String getMarginBottom() {
        return this.marginBottom;
    }

    public HtmlToPdfParam setMarginBottom(String marginBottom) {
        this.marginBottom = marginBottom;
        return this;
    }

    public String getMarginLeft() {
        return this.marginLeft;
    }

    public HtmlToPdfParam setMarginLeft(String marginLeft) {
        this.marginLeft = marginLeft;
        return this;
    }

    public String getMarginRight() {
        return this.marginRight;
    }

    public HtmlToPdfParam setMarginRight(String marginRight) {
        this.marginRight = marginRight;
        return this;
    }

    public String getMarginTop() {
        return this.marginTop;
    }

    public HtmlToPdfParam setMarginTop(String marginTop) {
        this.marginTop = marginTop;
        return this;
    }

    public boolean isDisableSmartShrinking() {
        return this.disableSmartShrinking;
    }

    public HtmlToPdfParam setDisableSmartShrinking(boolean disableSmartShrinking) {
        this.disableSmartShrinking = disableSmartShrinking;
        return this;
    }

    public boolean isPrintMediaType() {
        return this.printMediaType;
    }

    public HtmlToPdfParam setPrintMediaType(boolean printMediaType) {
        this.printMediaType = printMediaType;
        return this;
    }

    public String getPageHeight() {
        return this.pageHeight;
    }

    public HtmlToPdfParam setPageHeight(String pageHeight) {
        this.pageHeight = pageHeight;
        return this;
    }

    public String getPageWidth() {
        return this.pageWidth;
    }

    public HtmlToPdfParam setPageWidth(String pageWidth) {
        this.pageWidth = pageWidth;
        return this;
    }

    public Integer getDpi() {
        return this.dpi;
    }

    public HtmlToPdfParam setDpi(Integer dpi) {
        this.dpi = dpi;
        return this;
    }

    public String getPageSize() {
        return this.pageSize;
    }

    public HtmlToPdfParam setPageSize(String pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public HtmlToPdfParam setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getHeaderSpacing() {
        return this.headerSpacing;
    }

    public HtmlToPdfParam setHeaderSpacing(String headerSpacing) {
        this.headerSpacing = headerSpacing;
        return this;
    }

    public String getFooterSpacing() {
        return this.footerSpacing;
    }

    public HtmlToPdfParam setFooterSpacing(String footerSpacing) {
        this.footerSpacing = footerSpacing;
        return this;
    }

    public boolean isVertical() {
        return this.isVertical;
    }

    public HtmlToPdfParam setVertical(boolean isVertical) {
        this.isVertical = isVertical;
        return this;
    }

    public String getHeaderHtml() {
        return this.headerHtml;
    }

    public HtmlToPdfParam setHeaderHtml(String headerHtml) {
        this.headerHtml = headerHtml;
        return this;
    }

    public String getFooterHtml() {
        return this.footerHtml;
    }

    public HtmlToPdfParam setFooterHtml(String footerHtml) {
        this.footerHtml = footerHtml;
        return this;
    }

    public File getHeaderFile() {
        return this.headerFile;
    }

    public File getFooterFile() {
        return this.footerFile;
    }

    public String generateCmdParams() throws IOException {
        LinkedHashMap<String, String> paramsMap = new LinkedHashMap<String, String>();
        paramsMap.put("-T", this.marginTop);
        paramsMap.put("-B", this.marginBottom);
        paramsMap.put("-L", this.marginLeft);
        paramsMap.put("-R", this.marginRight);
        paramsMap.put("--dpi", this.dpi.toString());
        if (StringUtils.isNotBlank((String)this.title)) {
            paramsMap.put("--title", this.title);
        }
        if (this.disableSmartShrinking) {
            paramsMap.put("--disable-smart-shrinking", "");
        }
        if (this.printMediaType) {
            paramsMap.put("--print-media-type", "");
        }
        if (!this.isVertical) {
            paramsMap.put("-O", "Landscape");
        }
        this.setPageSize(paramsMap);
        this.setHeaderOrFooter(paramsMap);
        return this.generateCmdParams(paramsMap);
    }

    private void setHeaderOrFooter(Map<String, String> paramsMap) throws IOException {
        String fileName;
        if (StringUtils.isNotBlank((String)this.headerHtml)) {
            if (StringUtils.isNotBlank((String)this.headerSpacing)) {
                paramsMap.put("--header-spacing", this.headerSpacing);
            }
            fileName = UUIDGenerator.generateUUID() + ".header.html";
            this.headerFile = BaseFileUtils.createEmptyTmpFile(fileName, this.headerHtml);
            paramsMap.put("--header-html", this.headerFile.getAbsolutePath());
        }
        if (StringUtils.isNotBlank((String)this.footerHtml)) {
            if (StringUtils.isNotBlank((String)this.footerSpacing)) {
                paramsMap.put("--footer-spacing", this.footerSpacing);
            }
            fileName = UUIDGenerator.generateUUID() + ".footer.html";
            this.footerFile = BaseFileUtils.createEmptyTmpFile(fileName, this.footerHtml);
            paramsMap.put("--footer-html", this.footerFile.getAbsolutePath());
        }
    }

    private void setPageSize(Map<String, String> paramsMap) {
        if (StringUtils.isNotBlank((String)this.pageSize) && !LETTER_A5.equals(this.pageSize.trim())) {
            paramsMap.put("--page-size", this.pageSize);
            return;
        }
        if (LETTER_A5.equals(this.pageSize)) {
            this.pageHeight = "140mm";
            this.pageWidth = "216mm";
        }
        if (StringUtils.isNotBlank((String)this.pageHeight)) {
            paramsMap.put("--page-height", this.pageHeight);
        }
        if (StringUtils.isNotBlank((String)this.pageWidth)) {
            paramsMap.put("--page-width", this.pageWidth);
        }
    }

    private String generateCmdParams(Map<String, String> params) {
        if (MapUtils.isEmpty(params)) {
            return "";
        }
        StringBuffer cmd = new StringBuffer();
        for (String key : params.keySet()) {
            String value = params.get(key);
            cmd.append(key).append(" ").append(value).append(" ");
        }
        return cmd.toString();
    }
}

