/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.utils.excel;

import com.els.base.utils.excel.ObjToStrConverter;
import com.els.base.utils.excel.StrToObjConverter;
import java.util.Date;
import java.util.List;
import jxl.Cell;
import jxl.Sheet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;

public class DateConverter
implements StrToObjConverter<Date>,
ObjToStrConverter<Date> {
    private static final String DEFAULT_DATE_FORMATE = "yyyy-MM-dd HH:mm:ss";
    private String dateFormat;

    public String getDateFormat() {
        return this.dateFormat;
    }

    public DateConverter() {
    }

    public DateConverter(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public DateConverter setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
        return this;
    }

    @Override
    public Date convert(String content, List<Cell> rows, Sheet sheet) throws Exception {
        if (StringUtils.isBlank((String)content)) {
            return null;
        }
        if (StringUtils.isNotBlank((String)this.dateFormat)) {
            return DateUtils.parseDate((String)content, (String[])new String[]{this.dateFormat});
        }
        if (content.matches("\\d+")) {
            return new Date(Long.valueOf(content));
        }
        if (content.matches("\\d+-\\d+-\\d+\\s\\d+:\\d+:\\d+") || content.matches("\\d+-\\d+-\\d+")) {
            return DateUtils.parseDate((String)content, (String[])new String[]{DEFAULT_DATE_FORMATE, "yyyy-MM-dd"});
        }
        throw new RuntimeException("\u65e0\u6cd5\u8bc6\u522b\u8be5\u65e5\u671f\u683c\u5f0f");
    }

    @Override
    public String convert(Date t, Object item, int index) {
        if (StringUtils.isBlank((String)this.dateFormat)) {
            this.dateFormat = DEFAULT_DATE_FORMATE;
        }
        return DateFormatUtils.format((Date)t, (String)this.dateFormat);
    }
}

