/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.utils.excel;

import com.els.base.utils.excel.ObjToStrConverter;
import com.els.base.utils.excel.StrToObjConverter;
import java.util.List;
import jxl.Cell;
import jxl.Sheet;
import org.apache.commons.lang.StringUtils;

public class YesOrNoIntegerConverter
implements ObjToStrConverter<Integer>,
StrToObjConverter<Integer> {
    private static final String YES = "\u662f";
    private static final String NO = "\u5426";
    private static final Integer YES_INT = 1;
    private static final Integer NO_INT = 0;

    @Override
    public String convert(Integer t, Object item, int index) {
        if (t != null && t.equals(YES_INT)) {
            return YES;
        }
        if (t != null && t.equals(NO_INT)) {
            return NO;
        }
        return "";
    }

    @Override
    public Integer convert(String content, List<Cell> rows, Sheet sheet) throws Exception {
        if (StringUtils.isBlank((String)content)) {
            return null;
        }
        if (YES.equals(content.trim())) {
            return YES_INT;
        }
        if (NO.equals(content.trim())) {
            return NO_INT;
        }
        return null;
    }
}

