package com.els.base.utils.txtImport;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;

/**
 * @author linyuqin
 */
public class ConverterFactory {

    private final Map<String, StringToObjectConverter> toObjMap = new Hashtable<>();

    private static ConverterFactory factory = new ConverterFactory();

    /**
     * 注册默认的转换器
     */
    private void register() {
        toObjMap.put(Integer.class.toString(), new IntegerConverter());
        toObjMap.put(BigDecimal.class.toString(), new BigDecimalConverter());
        toObjMap.put(Date.class.toString(), new DateConverter());
        toObjMap.put(Long.class.toString(), new LongConverter());
        toObjMap.put(Double.class.toString(), new DoubleConverter());
    }

    public static StringToObjectConverter getDefaultToObjConverter(Class clazz) {
    	return factory.getToObjMap().get(clazz.toString());
    }

    private ConverterFactory() {
        super();
        this.register();
    }

    public Map<String, StringToObjectConverter> getToObjMap() {
        return toObjMap;
    }

}
