package com.els.base.utils.json;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;

/**
 * 从布尔值转化为整型的反序列化，true为1，false为0
 * @author hzy
 *
 */
public class IntegerFromBooleanDeserializer extends JsonDeserializer<Integer>{

	@Override
	public Integer deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
		
		boolean value = p.getValueAsBoolean(false);
		if (value) {
			return 1;
		}else{
			return 0;
		}
	}

}
