package com.els.base.utils.excel;

import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang.StringUtils;

import jxl.Cell;
import jxl.Sheet;

public class KeyAndValueMapConverter implements ObjToStrConverter<Object>, StrToObjConverter<Object> {
	
	private Map<Object, String> keyAndValueMap; 

	public KeyAndValueMapConverter(Map<Object, String> keyAndValueMap) {
		super();
		this.keyAndValueMap = keyAndValueMap;
	}

	@Override
	public String convert(Object t, Object item, int index) {
		if (keyAndValueMap == null || keyAndValueMap.size() == 0) {
			return "";
		}
		
		String value = keyAndValueMap.get(t);
		if (StringUtils.isBlank(value)) {
			return "";
		}
		
		return value;
	}

	@Override
	public Object convert(String content, List<Cell> rows, Sheet sheet) throws Exception {
		if (keyAndValueMap == null || keyAndValueMap.size() == 0) {
			return null;
		}
		
		Set<Object> keySet = keyAndValueMap.keySet();
		for (Object key : keySet) {
			String value = keyAndValueMap.get(key);
			
			if (value.equals(content)) {
				return key;
			}
		}
		
		return null;
	}
}
