/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.utils.reflect;

import com.esotericsoftware.reflectasm.MethodAccess;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.reflect.FieldUtils;

public abstract class ReflectUtils {
    private static Map<String, MethodAccess> classAndMethodAccessMap = new HashMap<String, MethodAccess>();

    public static Class<?> getFieldType(Object instance, String propertyName) {
        Map map;
        if (instance == null) {
            throw new IllegalArgumentException("instance doesn't accept null");
        }
        if (StringUtils.isBlank((String)propertyName)) {
            throw new IllegalArgumentException("propertyName doesn't accept null");
        }
        propertyName = propertyName.trim();
        if (instance instanceof Map && (map = (Map)instance).containsKey(propertyName)) {
            Object value = map.get(propertyName);
            if (value == null) {
                return null;
            }
            return value.getClass();
        }
        return FieldUtils.getField(instance.getClass(), (String)propertyName).getClass();
    }

    public static Object getValue(Object instance, String propertyName) {
        if (StringUtils.isBlank((String)propertyName)) {
            throw new IllegalArgumentException("can not accept null");
        }
        propertyName = propertyName.trim();
        while (propertyName.contains(".")) {
            String currentPropertyName = propertyName.split("\\.")[0];
            propertyName = propertyName.replaceAll(currentPropertyName + "\\.", "");
            instance = ReflectUtils.getPropertyValue(instance, currentPropertyName);
        }
        return ReflectUtils.getPropertyValue(instance, propertyName);
    }

    private static Object getPropertyValue(Object instance, String propertyName) {
        if (StringUtils.isBlank((String)propertyName)) {
            throw new IllegalArgumentException("can not accept null");
        }
        propertyName = propertyName.trim();
        if (instance instanceof Map) {
            Map map = (Map)instance;
            if (map.containsKey(propertyName)) {
                return map.get(propertyName);
            }
            throw new IllegalArgumentException("\u627e\u4e0d\u5230\u5c5e\u6027:" + propertyName);
        }
        String methodName = "get" + StringUtils.capitalize((String)propertyName.trim());
        try {
            return ReflectUtils.invokeMethod(instance, methodName, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setValue(Object instance, String propertyName, Object value) {
        if (StringUtils.isBlank((String)propertyName)) {
            throw new IllegalArgumentException("can not accept null");
        }
        propertyName = propertyName.trim();
        if (instance instanceof Map) {
            Map map = (Map)instance;
            map.put(propertyName, value);
            return;
        }
        String methodName = "set" + StringUtils.capitalize((String)propertyName.trim());
        try {
            ReflectUtils.invokeMethod(instance, methodName, value);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object invokeMethod(Object instance, String methodName, Object ... objects) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (instance == null) {
            throw new NullPointerException("instance \u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)methodName)) {
            throw new NullPointerException("methodName \u4e3a\u7a7a");
        }
        MethodAccess methodAccess = classAndMethodAccessMap.get(instance.getClass().getName());
        if (methodAccess == null) {
            methodAccess = MethodAccess.get(instance.getClass());
            classAndMethodAccessMap.put(instance.getClass().getName(), methodAccess);
        }
        return methodAccess.invoke(instance, methodName, objects);
    }

    public static Method findMethod(Object instance, String methodName, Object[] objects) {
        Method matchMethod = ReflectUtils.findMatchMethod(Arrays.asList(instance.getClass().getDeclaredMethods()), methodName, objects);
        if (matchMethod == null) {
            matchMethod = ReflectUtils.findMatchMethod(Arrays.asList(instance.getClass().getMethods()), methodName, objects);
        }
        if (matchMethod == null) {
            throw new IllegalArgumentException("\u627e\u4e0d\u5230\u8be5\u65b9\u6cd5");
        }
        return matchMethod;
    }

    private static Method findMatchMethod(List<Method> allDeclaredMethods, String methodName, Object[] objects) {
        List<Method> methodList = allDeclaredMethods.stream().filter(method -> method.getName().equals(methodName.trim())).filter(method -> {
            if (objects == null) {
                return method.getParameters().length == 0;
            }
            return objects.length == method.getParameters().length;
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(methodList)) {
            return null;
        }
        Method matchMethod = null;
        matchMethod = methodList.size() > 1 ? ReflectUtils.findMethod(methodList, objects) : methodList.get(0);
        return matchMethod;
    }

    private static boolean isSameMethod(Method declareMethod, Method method) {
        if (!method.getName().equals(declareMethod.getName())) {
            return false;
        }
        if (method.getParameters().length != declareMethod.getParameters().length) {
            return false;
        }
        for (int i = 0; i < method.getParameters().length; ++i) {
            if (method.getParameterTypes()[i].equals(declareMethod.getParameterTypes()[i])) continue;
            return false;
        }
        return true;
    }

    private static Method findMethod(List<Method> methodList, Object[] objects) {
        for (Method method : methodList) {
            boolean isMatch = true;
            for (int i = 0; i < method.getParameters().length; ++i) {
                if (objects[i] == null) {
                    throw new IllegalArgumentException("\u65b9\u6cd5\u51fa\u73b0\u91cd\u8f7d\uff0c\u4e14\u53c2\u6570\u4f20\u503c\u4e3anull\uff0c\u65e0\u6cd5\u8bc6\u522b\u5408\u9002\u7684\u65b9\u6cd5");
                }
                if (method.getParameterTypes()[i].equals(objects[i].getClass())) continue;
                isMatch = false;
                break;
            }
            if (!isMatch) continue;
            return method;
        }
        return null;
    }
}

