package com.els.base.utils.template;

import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Properties;

import org.beetl.core.Configuration;
import org.beetl.core.GroupTemplate;
import org.beetl.core.ReThrowConsoleErrorHandler;
import org.beetl.core.Template;
import org.beetl.core.resource.AllowAllMatcher;
import org.beetl.core.resource.ClasspathResourceLoader;
import org.beetl.core.resource.CompositeResourceLoader;
import org.beetl.core.resource.StartsWithMatcher;
import org.beetl.core.resource.StringTemplateResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

public class BeetlTemplateUtils {
	private static Logger logger = LoggerFactory.getLogger(BeetlTemplateUtils.class);
	
	/**
	 * BeetlKit 默认使用的GroupTemplate，用户可以设置新的
	 */
	public static GroupTemplate gt = null;
	
	private static final String PREFIX_BEETLE = "str:";

	static {
		StringTemplateResourceLoader stringResourceLoader = new StringTemplateResourceLoader();
		ClasspathResourceLoader classpathResourceLoader = new ClasspathResourceLoader("template/");
//		
		CompositeResourceLoader loader = new CompositeResourceLoader();
		loader.addResourceLoader(new StartsWithMatcher(PREFIX_BEETLE), stringResourceLoader);
		loader.addResourceLoader(new AllowAllMatcher(), classpathResourceLoader);
		
		Configuration cfg;
		try {
			cfg = Configuration.defaultConfiguration();
			cfg.setHtmlTagFlag("cms-");
			cfg.setHtmlTagStart("<cms-");
			cfg.setHtmlTagEnd("</cms-");

		} catch (IOException e) {
			throw new RuntimeException(e);
		}
		
		gt = new GroupTemplate(loader, cfg);
//		gt.registerFunction("beetlKit", new GetValueFunction());
		gt.setErrorHandler(new ReThrowConsoleErrorHandler());
		try {
			ResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver();
			Resource[] resources = resourceResolver.getResources("classpath*:/beetleTag/*.properties");
			
			Map<String, Class> tagName2Class = new HashMap<>();
			
			for (int i=0; resources!=null && i<resources.length; i++) {
				Properties properties = new Properties();
				properties.load(resources[i].getInputStream());
				
				Iterator<Object> keyIterator = properties.keySet().iterator();
				
				while (keyIterator.hasNext()) {
					String keyStr = (String) keyIterator.next();
					Class clazz = Class.forName(properties.getProperty(keyStr));
					
					if (tagName2Class.containsKey(keyStr)) {
						if (tagName2Class.get(keyStr).equals(clazz)) {
							continue;
						}
						throw new IllegalArgumentException(MessageFormat.format("出现重复的tag标签,已有一个[{0}],现在重复一个[{1}]", tagName2Class.get(keyStr), clazz));
					}
					
					tagName2Class.put(keyStr, clazz);
				}
			}
			
			Iterator<Entry<String, Class>> tagName2ClassIterator = tagName2Class.entrySet().iterator();
			while(tagName2ClassIterator.hasNext()){
				Entry<String, Class> tagNameAndClass = tagName2ClassIterator.next();
				gt.registerTag(tagNameAndClass.getKey(), tagNameAndClass.getValue());
			}
			
		} catch (ClassNotFoundException | IOException e) {
			logger.error("模板tag加载异常", e);
		}
	}
	
	/**
	 * 渲染模板，使用paras参数作为数据源，渲染结果作为字符串返回
	 * @param fileName template目录下的模板文件
	 * @param params
	 * @return
	 */
	public static String renderFromFile(String fileName, Map<String, Object> params) {
		Template t = gt.getTemplate(fileName);
		t.binding(params);
		return t.render();
	}
	
	/**
	 * 渲染模板，使用paras参数作为数据源，渲染结果作为字符串返回
	 * @param fileName template目录下的模板文件
	 * @param params
	 * @return
	 */
	public static String renderFromFile(String fileName, String varName, Object data) {
		Template t = gt.getTemplate(fileName);
		t.binding(varName, data);
		return t.render();
	}
	
	/**
	 * 渲染模板，使用paras参数作为数据源，渲染结果以流的方式写入
	 * @param fileName template目录下的模板文件
	 * @param params
	 * @return
	 */
	public static void renderFromFile(String fileName, Writer writer, Map<String, Object> params) {
		Template t = gt.getTemplate(fileName);
		t.binding(params);
		t.renderTo(writer);
	}
	
	/**
	 * 渲染模板，使用paras参数，渲染结果作为字符串返回
	 * @param template 模板的内容
	 * @param params
	 * @return
	 */
	public static String renderFromString(String template, String varName, Object data) {
		template = PREFIX_BEETLE.concat(template);
		Template t = gt.getTemplate(template);
		t.binding(varName, data);
		return t.render();
	}
	
	/**
	 * 渲染模板，使用paras参数作为数据源，渲染结果以流的方式写入
	 * @param  template 模板的内容
	 * @param writer
	 * @param paras
	 */
	public static void renderFromString(String template, Writer writer, Map<String, Object> params) {
		template = PREFIX_BEETLE.concat(template);
		Template t = gt.getTemplate(template);
		t.binding(params);
		t.renderTo(writer);
	}

}
