package com.els.base.utils.file;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

import org.apache.commons.io.FileUtils;

public class BaseFileUtils {
	
	/**
	 * 临时文件的存放目录
	 */
	private static final String TMP_DIR_NAME = "base_temp";
	
	/**
	 * 在用户目录创建临时文件
	 * @return
	 * @throws IOException 
	 */
	public static File createEmptyTmpFile(String fileName) throws IOException{
		
		String usrHome = System.getProperty("user.home");
		File file = new File(usrHome + File.separator + TMP_DIR_NAME + File.separator + fileName);
		FileUtils.touch(file);
		
		return file;
	}
	
	/**
	 * 在用户目录创建临时文件，并写入内容
	 * @return
	 * @throws IOException 
	 */
	public static File createEmptyTmpFile(String fileName, String content) throws IOException{
		
		String usrHome = System.getProperty("user.home");
		File file = new File(usrHome + File.separator + TMP_DIR_NAME + File.separator + fileName);
		FileUtils.touch(file);
		
		FileWriter writer = new FileWriter(file);
//		IOUtils.copy(new StringReader(content), writer);
		FileUtils.writeByteArrayToFile(file, content.getBytes());
		
		return file;
	}

}
