/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.utils.excel;

import com.els.base.utils.excel.ObjToStrConverter;
import com.els.base.utils.excel.StrToObjConverter;
import java.util.List;
import jxl.Cell;
import jxl.Sheet;
import org.apache.commons.lang.StringUtils;

public class YesOrNoStringConverter
implements ObjToStrConverter<String>,
StrToObjConverter<String> {
    private static final String YES = "\u662f";
    private static final String NO = "\u5426";
    private static final String YES_STR = "Y";
    private static final String NO_STR = "N";

    @Override
    public String convert(String t, Object item, int index) {
        if (t != null && t.trim().equals(YES_STR)) {
            return YES;
        }
        if (t != null && t.trim().equals(NO_STR)) {
            return NO;
        }
        return "";
    }

    @Override
    public String convert(String content, List<Cell> rows, Sheet sheet) throws Exception {
        if (StringUtils.isBlank((String)content)) {
            return null;
        }
        if (YES.equals(content.trim())) {
            return YES_STR;
        }
        if (NO.equals(content.trim())) {
            return NO_STR;
        }
        return null;
    }
}

