package com.els.base.utils.encryption;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

import com.els.base.utils.json.JsonUtils;
import com.fasterxml.jackson.core.JsonProcessingException;

public class Md5Utils {
	
	private final static String[] hexDigits = {"0", "1", "2", "3", "4", "5", "6", "7",
            "8", "9", "a", "b", "c", "d", "e", "f"};
	
	public static String md5Object(Object object) throws NoSuchAlgorithmException, UnsupportedEncodingException, JsonProcessingException{
		if (object == null) {
			return "md5_null";
		}
		return md5Encode(JsonUtils.writeValueAsString(object));
	}
	
	/**
     * MD5编码
     * @param origin 原始字符串
     * @return 经过MD5加密之后的结果
	 * @throws NoSuchAlgorithmException 
	 * @throws UnsupportedEncodingException 
     */
    public static String md5Encode(String origin) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        String resultString = null;
        resultString = origin;
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(resultString.getBytes("UTF-8"));
        resultString = byteArrayToHexString(md.digest());
        return resultString;
    }
    
    /**
     * 转换字节数组为16进制字串
     * @param b 字节数组
     * @return 16进制字串
     */
    public static String byteArrayToHexString(byte[] b) {
        StringBuilder resultSb = new StringBuilder();
        for (byte aB : b) {
            resultSb.append(byteToHexString(aB));
        }
        return resultSb.toString();
    }
    
    /**
     * 转换byte到16进制
     * @param b 要转换的byte
     * @return 16进制格式
     */
    private static String byteToHexString(byte b) {
        int n = b;
        if (n < 0) {
            n = 256 + n;
        }
        int d1 = n / 16;
        int d2 = n % 16;
        return hexDigits[d1] + hexDigits[d2];
    }

}
