package com.els.base.utils.uuid;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;

public class UUIDGenerator {
	
	public static final String PARAMETER_OBJECT_KEY = "_parameter";
	
	/**
	 * 生成uuid
	 * @return
	 */
	public static String generateUUID(){
//		return UUID.randomUUID().toString().replaceAll("-", "");
		
		StringBuffer uuid = new StringBuffer();
		uuid.append(DateFormatUtils.format(new Date(), "yyyyMMddHHmmss"));
		uuid.append('-');
		uuid.append(UUID.randomUUID().toString().replaceAll("-", ""));
		return uuid.substring(0, 32);
	}
	
	public static String generateUUIDAndSetId(HashMap<String, Object> mybatisSqlContextMap){
		return generateUUIDAndSetId(mybatisSqlContextMap, "id");
	}
	
	public static String generateUUIDAndSetId(HashMap<String, Object> mybatisSqlContextMap, String propertyName){
		String uuid = generateUUID();
		try {
			Object object = mybatisSqlContextMap.get(PARAMETER_OBJECT_KEY);
			
			String nameOfGetMethod = "get" + StringUtils.capitalize(propertyName);
			Method getIdMethod = object.getClass().getMethod(nameOfGetMethod);
			if (getIdMethod != null) {
				Object id = getIdMethod.invoke(object);
				if (id != null && id instanceof String && StringUtils.isNotBlank((String)id)) {
					return (String) id;
				}
			}
			
			String nameOfSetMethod = "set" + StringUtils.capitalize(propertyName);
			Method setIdMethod = object.getClass().getMethod(nameOfSetMethod, String.class);
			if (setIdMethod != null) {
				setIdMethod.invoke(object, uuid);
			}
		} catch (NoSuchMethodException e) {
			e.printStackTrace();
		} catch (SecurityException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
		} catch (InvocationTargetException e) {
			e.printStackTrace();
		}
		return uuid;
	}
	
//	public static void main(String[] args) {
//		System.out.println(generateUUID());
//	}
	
}
