package com.els.base.utils.txtImport;

import org.apache.commons.lang.StringUtils;

import java.math.BigDecimal;

/**
 * BigDecimal转换器,如果内容为空则默认为0
 * @author linyuqiin
 *
 */
public class BigDecimalConverter implements StringToObjectConverter<BigDecimal>{

	@Override
	public BigDecimal convert(String content) {
		//如果为空,就默认为0
		if(StringUtils.isEmpty(content) || content.equals("null")){
			content = "0";
		}
		content = content.trim().replaceAll("\\s+", "");
		BigDecimal num;
		try {
			num = new BigDecimal(content);
		} catch (Exception e) {
			throw new IllegalArgumentException("'"+content+"'" +"无法转为数字!");
		}
		return num;
	}
}
