package com.els.base.utils.json;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;

/**
 * 反序列化忽略<p/>
 * 因为jackson的 JsonIgnore注解，会忽略序列化和反序列化，而功能需求上，只要忽略反序列化。
 * @author hzy
 *
 */
public class IgnoreDeserialzer extends JsonDeserializer<Object> {

	@Override
	public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
		//执行这步，让解析的游标，走到下一个属性
		p.readValueAsTree();
		return null;
	}

}
