/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.utils.excel;

import com.els.base.utils.excel.ObjToStrConverter;
import com.els.base.utils.excel.StrToObjConverter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jxl.Cell;
import jxl.Sheet;
import org.apache.commons.lang.StringUtils;

public class KeyAndValueMapConverter
implements ObjToStrConverter<Object>,
StrToObjConverter<Object> {
    private Map<Object, String> keyAndValueMap;

    public KeyAndValueMapConverter(Map<Object, String> keyAndValueMap) {
        this.keyAndValueMap = keyAndValueMap;
    }

    @Override
    public String convert(Object t, Object item, int index) {
        if (this.keyAndValueMap == null || this.keyAndValueMap.size() == 0) {
            return "";
        }
        String value = this.keyAndValueMap.get(t);
        if (StringUtils.isBlank((String)value)) {
            return "";
        }
        return value;
    }

    @Override
    public Object convert(String content, List<Cell> rows, Sheet sheet) throws Exception {
        if (this.keyAndValueMap == null || this.keyAndValueMap.size() == 0) {
            return null;
        }
        Set<Object> keySet = this.keyAndValueMap.keySet();
        for (Object key : keySet) {
            String value = this.keyAndValueMap.get(key);
            if (!value.equals(content)) continue;
            return key;
        }
        return null;
    }
}

