/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.utils.i18n;

import com.els.base.utils.SpringContextHolder;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.LocaleUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.servlet.LocaleContextResolver;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.support.RequestContextUtils;

public class I18nUtils {
    private static Logger logger = LoggerFactory.getLogger(I18nUtils.class);
    public static final String COOKIE_I18N = "COOKIE_I18N";
    public static final String URL_PARAM_I18N = "local_i18n";
    private static Pattern domainRegex = Pattern.compile("^.+?(\\.\\w+\\.[a-z]+)$");

    public static void setLocalByRequest(HttpServletRequest request, HttpServletResponse response) {
        String newLocale = request.getParameter(URL_PARAM_I18N);
        if (StringUtils.isBlank((String)newLocale)) {
            return;
        }
        LocaleResolver localeResolver = RequestContextUtils.getLocaleResolver((HttpServletRequest)request);
        if (localeResolver == null) {
            try {
                localeResolver = (LocaleResolver)SpringContextHolder.getBean("localeResolver");
            }
            catch (Exception e) {
                logger.warn("\u8bbe\u7f6e\u56fd\u9645\u5316\u5f02\u5e38\uff0c\u5bb9\u5668\u4e2d\u627e\u4e0d\u5230\u56fd\u9645\u5316\u7684\u5904\u7406\u5668[localeResolver]");
            }
        }
        if (localeResolver == null) {
            try {
                localeResolver = SpringContextHolder.getOneBean(LocaleResolver.class);
            }
            catch (Exception e) {
                logger.warn("\u8bbe\u7f6e\u56fd\u9645\u5316\u5f02\u5e38\uff0c\u5bb9\u5668\u4e2d\u627e\u4e0d\u5230\u56fd\u9645\u5316\u7684\u5904\u7406\u5668[LocaleResolver.class]");
            }
        }
        if (localeResolver != null) {
            if (localeResolver instanceof LocaleContextResolver) {
                LocaleContextResolver tmp = (LocaleContextResolver)localeResolver;
                tmp.resolveLocaleContext(request);
            } else {
                localeResolver.resolveLocale(request);
            }
        }
        Cookie i18nCookie = new Cookie(COOKIE_I18N, newLocale);
        i18nCookie.setPath("/");
        i18nCookie.setMaxAge(Integer.MAX_VALUE);
        Matcher matcher = domainRegex.matcher(request.getServerName());
        if (matcher.find()) {
            i18nCookie.setDomain(matcher.group(1));
        }
        response.addCookie(i18nCookie);
    }

    public static Locale getByLocale(String localStr) {
        String[] array;
        if (StringUtils.isBlank((String)localStr)) {
            return null;
        }
        if (localStr.contains("-")) {
            localStr = localStr.replaceAll("\\-", "_");
        }
        if ((array = localStr.split("_")).length > 1) {
            localStr = array[0] + "_" + array[1].toUpperCase();
        }
        Locale locale = null;
        try {
            locale = LocaleUtils.toLocale((String)localStr);
        }
        catch (Exception e) {
            logger.warn("\u4f20\u53c2\u9519\u8bef\uff0c\u4e0d\u652f\u6301\u8be5\u56fd\u9645\u5316:" + localStr);
            locale = new Locale("zh", "CN");
        }
        return locale;
    }

    public static String getMessage(String i18nCode) {
        Locale locale = LocaleContextHolder.getLocale();
        if (locale == null) {
            return null;
        }
        String i18nMsg = SpringContextHolder.getApplicationContext().getMessage(i18nCode, null, locale);
        return i18nMsg;
    }
}

