package com.els.base.utils.txtImport;

import org.apache.commons.lang.StringUtils;

/**
 * @author linyuqin
 */
public class IntegerConverter implements StringToObjectConverter<Integer> {

	@Override
	public Integer convert(String content) throws Exception {
		if (StringUtils.isEmpty(content)) {
			return 0;
		}
		Integer num = null;
		try {
			num = Integer.parseInt(content);
		} catch (NumberFormatException e) {
			throw new NumberFormatException("'"+content+"'" +"无法转为数字!");
		}
		return num;
	}
}
